/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataSourceSupplier;
import org.infrastructurebuilder.data.IBDataStreamIdentifier;
import org.infrastructurebuilder.data.ingest.IBDataSourceSupplierFactory;
import org.infrastructurebuilder.data.ingest.IBDataSourceSupplierMapper;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.util.LoggerSupplier;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;
import org.slf4j.Logger;

@Named
public class DefaultIBDataSourceSupplierFactory
implements IBDataSourceSupplierFactory {
    private final TypeToExtensionMapper mapper;
    private final Logger log;
    private final List<IBDataSourceSupplierMapper> dssMappers;
    private final PathSupplier workingPathSupplier;

    @Inject
    public DefaultIBDataSourceSupplierFactory(LoggerSupplier l, TypeToExtensionMapper t2e, List<IBDataSourceSupplierMapper> dssMappers, @Named(value="ibdata-working-path-supplier") PathSupplier workingPathSupplier) {
        this.log = (Logger)Objects.requireNonNull(l).get();
        this.mapper = Objects.requireNonNull(t2e);
        this.dssMappers = Objects.requireNonNull(dssMappers);
        this.workingPathSupplier = Objects.requireNonNull(workingPathSupplier);
    }

    public Path getTargetPath() {
        return (Path)this.workingPathSupplier.get();
    }

    public final SortedMap<String, IBDataSourceSupplier> mapIngestionToSourceSuppliers(Ingestion i) {
        List k = i.getDataSet().getStreams().stream().map(dStream -> {
            IBDataSourceSupplierMapper first = this.dssMappers.stream().filter(m -> m.respondsTo(dStream)).findFirst().orElseThrow(() -> new IBDataException("No data sources are available for " + dStream.getTemporaryId()));
            return first.getSupplierFor(dStream.getTemporaryId(), (IBDataStreamIdentifier)dStream);
        }).collect(Collectors.toList());
        return k.stream().collect(Collectors.toMap(IBDataSourceSupplier::getId, Function.identity(), (prev, now) -> now, () -> new TreeMap()));
    }
}

