/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.archive;

import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="ibdata", defaultPhase=LifecyclePhase.SITE, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresProject=true, threadSafe=true)
public class IBDataTransactionReport
extends AbstractMavenReport {
    private static final String DESCRIPTION = "This report details the executions of ingestions and transactions within an IBData build";
    private static final String IB_DATA_TRANSACTION_REPORT_NAME = "IBData Transaction Report";
    private static final String IBDATA_TRX_REPORT = "ibdata-trx-report";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public String getOutputName() {
        return IBDATA_TRX_REPORT;
    }

    public String getName(Locale locale) {
        return IB_DATA_TRANSACTION_REPORT_NAME;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        Log logger = this.getLog();
        logger.info((CharSequence)("Generating " + this.getOutputName() + ".html for " + this.project.getName() + " " + this.project.getVersion()));
        Map pc = this.getPluginContext();
        Sink mainSink = this.getSink();
        if (mainSink == null) {
            throw new MavenReportException("Could not get the Doxia sink");
        }
        mainSink.head();
        mainSink.title();
        mainSink.text("IBData Report for " + this.project.getName() + " " + this.project.getVersion());
        mainSink.title_();
        mainSink.head_();
        mainSink.body();
        mainSink.section1();
        mainSink.sectionTitle1();
        mainSink.text("IBData Report for " + this.project.getName() + " " + this.project.getVersion());
        mainSink.sectionTitle1_();
        mainSink.paragraph();
        mainSink.text("This page provides data about the IBData transactions that occurred within this build ");
        mainSink.paragraph_();
        mainSink.section1_();
        mainSink.body_();
    }
}

