/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import com.googlecode.download.maven.plugin.internal.HttpFileRequester;
import com.googlecode.download.maven.plugin.internal.LoggingProgressReport;
import com.googlecode.download.maven.plugin.internal.ProgressReport;
import com.googlecode.download.maven.plugin.internal.SignatureUtils;
import com.googlecode.download.maven.plugin.internal.SilentProgressReport;
import com.googlecode.download.maven.plugin.internal.cache.DownloadCache;
import java.io.File;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.StringUtils;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.util.BasicCredentials;
import org.infrastructurebuilder.util.IBUtils;
import org.infrastructurebuilder.util.artifacts.Checksum;
import org.infrastructurebuilder.util.files.BasicIBChecksumPathType;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;
import org.slf4j.Logger;

public class WGetter {
    private final WGet wget = new WGet();

    public WGetter(Logger log, Optional<BasicCredentials> creds, TypeToExtensionMapper t2e) {
        DefaultLog l2 = new DefaultLog((org.codehaus.plexus.logging.Logger)new ConsoleLogger(0, WGetter.class.getCanonicalName()));
        this.wget.setLog((Log)l2);
        Objects.requireNonNull(creds).ifPresent(bc -> {
            this.wget.setUsername(bc.getKeyId());
            this.wget.setPassword(bc.getSecret().orElse(null));
        });
        this.wget.setT2EMapper(Objects.requireNonNull(t2e));
    }

    public final synchronized Optional<IBChecksumPathType> collectCacheAndCopyToChecksumNamedFile(Path workingPath, URL source, Optional<Checksum> checksum, Path cacheDirectory, Optional<String> type, boolean interactiveMode, int retries, int readTimeOut, boolean skipCache) {
        this.wget.setOutputPath(workingPath);
        Objects.requireNonNull(checksum).ifPresent(c -> this.wget.setSha512(c.toString().toLowerCase()));
        this.wget.setUri((URI)IBDataException.cet.withReturningTranslation(() -> Objects.requireNonNull(source).toURI()));
        this.wget.setFailOnError(false);
        this.wget.setOverwrite(false);
        this.wget.setCacheDirectory(Objects.requireNonNull(cacheDirectory).toAbsolutePath().toFile());
        this.wget.setInteractiveMode(interactiveMode);
        this.wget.setRetries(retries);
        this.wget.setReadTimeOut(readTimeOut);
        this.wget.setSkipCache(skipCache);
        this.wget.setCheckSignature(checksum.isPresent());
        this.wget.setMimeType(type.orElse("application/octet-stream"));
        return (Optional)IBDataException.cet.withReturningTranslation(() -> this.wget.downloadIt());
    }

    private static class WGet {
        private static final PoolingHttpClientConnectionManager CONN_POOL = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(SSLContexts.createSystemDefault(), new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier())).build(), null, null, null, 1L, TimeUnit.MINUTES);
        private URI uri;
        private boolean overwrite;
        private Path outputPath;
        private String sha512;
        private String username;
        private String password;
        private int retries;
        private int readTimeOut;
        private boolean skipCache;
        private File cacheDirectory;
        private boolean failOnError;
        private boolean checkSignature;
        private Log log;
        private boolean interactiveMode = false;
        private ProxyInfo proxyInfo;
        private String mimeType = "application/octet-stream";
        private TypeToExtensionMapper t2e;

        private WGet() {
        }

        public Log getLog() {
            return this.log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Optional<IBChecksumPathType> downloadIt() throws MojoExecutionException, MojoFailureException {
            if (StringUtils.isNotBlank((String)this.username) || StringUtils.isNotBlank((String)this.password)) {
                throw new MojoExecutionException("Specify either serverId or username/password, not both");
            }
            if (this.retries < 1) {
                throw new MojoFailureException("retries must be at least 1");
            }
            this.getLog().debug((CharSequence)("Cache is: " + this.cacheDirectory.getAbsolutePath()));
            DownloadCache cache = new DownloadCache(this.cacheDirectory);
            Path outputDirectory = this.outputPath;
            String outputFileName = UUID.randomUUID().toString();
            IBDataException.cet.withTranslation(() -> Files.createDirectories(outputDirectory, new FileAttribute[0]));
            File outputFile = outputDirectory.resolve(outputFileName).toFile();
            try {
                boolean haveFile = outputFile.exists();
                if (haveFile) {
                    boolean signatureMatch = true;
                    if (this.checkSignature) {
                        String expectedDigest = null;
                        String algorithm = null;
                        if (this.sha512 != null) {
                            expectedDigest = this.sha512;
                            algorithm = "SHA-512";
                        }
                        if (expectedDigest != null) {
                            try {
                                SignatureUtils.verifySignature((File)outputFile, (String)expectedDigest, (MessageDigest)MessageDigest.getInstance(algorithm));
                            }
                            catch (MojoFailureException e) {
                                this.getLog().warn((CharSequence)("The local version of file " + outputFile.getName() + " doesn't match the expected signature. You should consider checking the specified signature is correctly set."));
                                signatureMatch = false;
                            }
                        }
                    }
                    if (!signatureMatch) {
                        outputFile.delete();
                        haveFile = false;
                    } else if (!this.overwrite) {
                        this.getLog().info((CharSequence)"File already exist, skipping");
                    } else {
                        haveFile = false;
                    }
                }
                if (!haveFile) {
                    File cached = cache.getArtifact(this.uri, null, null, this.sha512);
                    if (!this.skipCache && cached != null && cached.exists()) {
                        this.getLog().info((CharSequence)("Got from cache: " + cached.getAbsolutePath()));
                        Files.copy(cached.toPath(), outputFile.toPath(), new CopyOption[0]);
                    } else {
                        boolean done = false;
                        while (!done && this.retries > 0) {
                            try {
                                this.doGet(outputFile);
                                if (this.sha512 != null) {
                                    SignatureUtils.verifySignature((File)outputFile, (String)this.sha512, (MessageDigest)MessageDigest.getInstance("SHA-512"));
                                }
                                done = true;
                            }
                            catch (Exception ex) {
                                this.getLog().warn((CharSequence)"Could not get content", (Throwable)ex);
                                --this.retries;
                                if (this.retries <= 0) continue;
                                this.getLog().warn((CharSequence)("Retrying (" + this.retries + " more)"));
                            }
                        }
                        if (!done) {
                            if (this.failOnError) {
                                throw new MojoFailureException("Could not get content");
                            }
                            this.getLog().warn((CharSequence)"Not failing download despite download failure.");
                            return Optional.empty();
                        }
                    }
                }
                Checksum finalChecksum = this.sha512 == null ? new Checksum(outputFile.toPath()) : new Checksum(this.sha512);
                String finalFileName = ((UUID)finalChecksum.asUUID().get()).toString() + this.t2e.getExtensionForType(this.mimeType);
                Path newTarget = this.outputPath.resolve(finalFileName);
                try {
                    IBUtils.moveAtomic((Path)outputFile.toPath(), (Path)newTarget);
                }
                finally {
                    outputFile.delete();
                }
                cache.install(this.uri, newTarget.toFile(), null, null, this.sha512);
                Path outPath = newTarget;
                BasicIBChecksumPathType retVal = new BasicIBChecksumPathType(outPath, finalChecksum, Optional.ofNullable(this.mimeType).orElse("application/octet-stream"));
                return Optional.of(retVal);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("IO Error", ex);
            }
        }

        private void doGet(File outputFile) throws Exception {
            SystemDefaultRoutePlanner routePlanner;
            RequestConfig requestConfig;
            if (this.readTimeOut > 0) {
                this.getLog().info((CharSequence)("Read Timeout is set to " + this.readTimeOut + " milliseconds (apprx " + Math.round((double)this.readTimeOut * 1.66667E-5) + " minutes)"));
                requestConfig = RequestConfig.custom().setConnectTimeout(this.readTimeOut).setSocketTimeout(this.readTimeOut).build();
            } else {
                requestConfig = RequestConfig.DEFAULT;
            }
            BasicCredentialsProvider credentialsProvider = null;
            if (StringUtils.isNotBlank((String)this.username)) {
                this.getLog().debug((CharSequence)"providing custom authentication");
                this.getLog().debug((CharSequence)("username: " + this.username + " and password: ***"));
                credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(this.uri.getHost(), this.uri.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            }
            if (this.proxyInfo != null && this.proxyInfo.getHost() != null && "HTTP".equals(this.proxyInfo.getType())) {
                routePlanner = new DefaultProxyRoutePlanner(new HttpHost(this.proxyInfo.getHost(), this.proxyInfo.getPort()));
                if (this.proxyInfo.getUserName() != null) {
                    Object creds = this.proxyInfo.getNtlmHost() != null || this.proxyInfo.getNtlmDomain() != null ? new NTCredentials(this.proxyInfo.getUserName(), this.proxyInfo.getPassword(), this.proxyInfo.getNtlmHost(), this.proxyInfo.getNtlmDomain()) : new UsernamePasswordCredentials(this.proxyInfo.getUserName(), this.proxyInfo.getPassword());
                    AuthScope authScope = new AuthScope(this.proxyInfo.getHost(), this.proxyInfo.getPort());
                    if (credentialsProvider == null) {
                        credentialsProvider = new BasicCredentialsProvider();
                    }
                    credentialsProvider.setCredentials(authScope, (Credentials)creds);
                }
            } else {
                routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
            }
            CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)CONN_POOL).setConnectionManagerShared(true).setRoutePlanner((HttpRoutePlanner)routePlanner).build();
            HttpFileRequester fileRequester = new HttpFileRequester(httpClient, (ProgressReport)(this.interactiveMode ? new LoggingProgressReport(this.getLog()) : new SilentProgressReport(this.getLog())));
            HttpClientContext clientContext = HttpClientContext.create();
            clientContext.setRequestConfig(requestConfig);
            if (credentialsProvider != null) {
                clientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            fileRequester.download(this.uri, outputFile, (HttpContext)clientContext);
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public void setOutputPath(Path outputPath) {
            this.outputPath = outputPath;
        }

        public void setSha512(String sha512) {
            this.sha512 = sha512;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setRetries(int retries) {
            this.retries = retries;
        }

        public void setReadTimeOut(int readTimeOut) {
            this.readTimeOut = readTimeOut;
        }

        public void setSkipCache(boolean skipCache) {
            this.skipCache = skipCache;
        }

        public void setCacheDirectory(File cacheDirectory) {
            this.cacheDirectory = cacheDirectory;
        }

        public void setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
        }

        public void setCheckSignature(boolean checkSignature) {
            this.checkSignature = checkSignature;
        }

        public void setInteractiveMode(boolean interactiveMode) {
            this.interactiveMode = interactiveMode;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public void setT2EMapper(TypeToExtensionMapper t2e) {
            this.t2e = t2e;
        }

        public void setLog(Log log) {
            this.log = log;
        }
    }
}

