/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataSource;
import org.infrastructurebuilder.data.IBDataSourceSupplier;
import org.infrastructurebuilder.data.ingest.AbstractIBDataSourceSupplierMapper;
import org.infrastructurebuilder.data.ingest.DefaultIBDataSource;
import org.infrastructurebuilder.data.ingest.DefaultIBDataStreamIdentifierConfigBean;
import org.infrastructurebuilder.util.LoggerSupplier;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;
import org.slf4j.Logger;

@Named
public class DefaultIBDataSourceSupplierMapper
extends AbstractIBDataSourceSupplierMapper {
    public static final List<String> HEADERS = Arrays.asList("http://", "https://", "file:", "zip:", "jar:");

    @Inject
    public DefaultIBDataSourceSupplierMapper(LoggerSupplier l, TypeToExtensionMapper t2e) {
        super((Logger)Objects.requireNonNull(l).get(), Objects.requireNonNull(t2e));
    }

    public List<String> getHeaders() {
        return HEADERS;
    }

    public IBDataSourceSupplier getSupplierFor(DefaultIBDataStreamIdentifierConfigBean v) {
        return new AbstractIBDataSourceSupplierMapper.DefaultIBDataSourceSupplier((AbstractIBDataSourceSupplierMapper)this, v.getTemporaryId(), (IBDataSource)new DefaultIBDataSource(this.getLog(), (String)v.getURL().orElseThrow(() -> new IBDataException("No url for " + v.getTemporaryId())), v.getName(), v.getDescription(), Optional.ofNullable(v.getChecksum()), Optional.of(v.getMetadata()), Optional.ofNullable(v.getMimeType()), this.getMapper()));
    }
}

