/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataSourceSupplier;
import org.infrastructurebuilder.data.ingest.IBDataSourceSupplierFactory;
import org.infrastructurebuilder.data.ingest.IBDataSourceSupplierMapper;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.util.LoggerSupplier;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;
import org.slf4j.Logger;

@Named
public class DefaultIBDataSourceSupplierFactory
implements IBDataSourceSupplierFactory {
    private final TypeToExtensionMapper mapper;
    private final Logger log;
    private final List<IBDataSourceSupplierMapper> dssMappers;

    @Inject
    public DefaultIBDataSourceSupplierFactory(LoggerSupplier l, TypeToExtensionMapper t2e, List<IBDataSourceSupplierMapper> dssMappers) {
        this.log = (Logger)Objects.requireNonNull(l).get();
        this.mapper = Objects.requireNonNull(t2e);
        this.dssMappers = Objects.requireNonNull(dssMappers);
    }

    public final SortedMap<String, IBDataSourceSupplier> mapIngestionToSourceSuppliers(Ingestion i) {
        List k = i.getDataSet().getStreams().stream().map(v -> {
            IBDataSourceSupplierMapper first = this.dssMappers.stream().filter(m -> m.respondsTo(v)).findFirst().orElseThrow(() -> new IBDataException("No data sources are available for " + v.getTemporaryId()));
            return first.getSupplierFor(v);
        }).collect(Collectors.toList());
        return k.stream().collect(Collectors.toMap(IBDataSourceSupplier::getId, Function.identity(), (prev, now) -> now, () -> new TreeMap()));
    }
}

