/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.archive;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.infrastructurebuilder.data.AbstractIBDataMojo;
import org.infrastructurebuilder.data.archive.IBDataPackageMavenComponent;
import org.infrastructurebuilder.data.archiver.DefaultIBDataMavenArchiveFinalizer;
import org.infrastructurebuilder.data.archiver.IBDataLateBindingFinalizerConfigSupplier;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.infrastructurebuilder.util.logging.SLF4JFromMavenLogger;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class IBDataPackagingMojo
extends AbstractIBDataMojo {
    @Parameter
    private final MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Component(hint="default-ibdata")
    private ArchiveFinalizer archiveFinalizer;
    @Parameter(property="maven.jar.classifier")
    private String classifier;
    @Component
    IBDataPackageMavenComponent component;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/MANIFEST.MF", required=true, readonly=true)
    private File defaultManifestFile;
    @Parameter(property="maven.ibdata.finalName", defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter(property="maven.jar.forceCreation", defaultValue="false")
    private boolean forceCreation;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="maven.jar.skipIfEmpty", defaultValue="false")
    private boolean skipIfEmpty;
    @Component(role=Archiver.class, hint="ibdata")
    private JarArchiver theArchiver;
    @Parameter(property="maven.jar.useDefaultManifestFile", defaultValue="false")
    private boolean useDefaultManifestFile;

    public File createArchive(IBChecksumPathType context) throws MojoExecutionException {
        File jarFile = this.getJarFile(this.outputDirectory, this.finalName, this.getClassifier());
        MavenArchiver archiver = new MavenArchiver();
        IBDataLateBindingFinalizerConfigSupplier lbconfig = new IBDataLateBindingFinalizerConfigSupplier();
        lbconfig.setT((Object)context);
        this.theArchiver.addArchiveFinalizer((ArchiveFinalizer)new DefaultIBDataMavenArchiveFinalizer(() -> new SLF4JFromMavenLogger((Object)this.getLog()), lbconfig));
        archiver.setArchiver(this.theArchiver);
        archiver.setOutputFile(jarFile);
        this.archive.setForced(this.forceCreation);
        try {
            if (!Optional.ofNullable(context.getPath()).map(f -> Files.exists(f, LinkOption.NOFOLLOW_LINKS) && Files.isDirectory(f, LinkOption.NOFOLLOW_LINKS)).orElse(false).booleanValue()) {
                this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion!");
            }
            File existingManifest = this.getDefaultManifestFile();
            if (this.useDefaultManifestFile && existingManifest.exists() && this.archive.getManifestFile() == null) {
                this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + existingManifest.getPath()));
                this.archive.setManifestFile(existingManifest);
            }
            archiver.createArchive(this.session, this.getProject(), this.archive);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR", e);
        }
    }

    public File getDefaultManifestFile() {
        return this.defaultManifestFile;
    }

    private String getClassifier() {
        return "";
    }

    @Override
    protected void _execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Executing Packaging");
        Map pc = this.getPluginContext();
        if (!pc.containsKey("IBDATA_INGESTION_TARGET_@3123") && !pc.containsKey("IBDATA_TRANSFORMATION_TARGET_@3123")) {
            throw new MojoExecutionException("Target does not exist");
        }
        if (pc.containsKey("IBDATA_INGESTION_TARGET_@3123") && pc.containsKey("IBDATA_TRANSFORMATION_TARGET_@3123")) {
            throw new MojoExecutionException("Cannot package ingestion and transformation at the same time");
        }
        IBChecksumPathType context = (IBChecksumPathType)pc.getOrDefault("IBDATA_INGESTION_TARGET_@3123", pc.get("IBDATA_TRANSFORMATION_TARGET_@3123"));
        Path target = context.getPath();
        this.getLog().debug((CharSequence)("Context payload acquired " + target.toString()));
        try {
            if (this.skipIfEmpty && (!Files.exists(target, LinkOption.NOFOLLOW_LINKS) || Files.list(target).collect(Collectors.toList()).size() < 1)) {
                this.getLog().info((CharSequence)"Skipping packaging of the IBData Archive");
            } else {
                File jarFile = this.createArchive(context);
                File ftest = this.getProject().getArtifact().getFile();
                if (ftest != null && ftest.isFile()) {
                    throw new MojoExecutionException("You have to use a classifier to attach supplemental artifacts to the project instead of replacing them.");
                }
                this.getLog().debug((CharSequence)("Setting project artifact to " + jarFile));
                this.getProject().getArtifact().setFile(jarFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Something went wrong in execute()", (Exception)e);
        }
        pc.remove("IBDATA_INGESTION_TARGET_@3123");
        pc.remove("IBDATA_TRANSFORMATION_TARGET_@3123");
    }

    protected File getJarFile(File basedir, String finalName, String classifier) {
        if (basedir == null) {
            throw new IllegalArgumentException("basedir is not allowed to be null");
        }
        if (finalName == null) {
            throw new IllegalArgumentException("finalName is not allowed to be null");
        }
        StringBuilder fileName = new StringBuilder(finalName);
        if (this.hasClassifier()) {
            fileName.append("-").append(classifier);
        }
        fileName.append(".jar");
        return new File(basedir, fileName.toString());
    }

    protected boolean hasClassifier() {
        boolean result = false;
        if (this.getClassifier() != null && this.getClassifier().trim().length() > 0) {
            result = true;
        }
        return result;
    }

    @Override
    protected IBDataPackageMavenComponent getComponent() {
        return this.component;
    }
}

