/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.infrastructurebuilder.data.AbstractIBDataMavenComponent;
import org.infrastructurebuilder.data.IBDataEngine;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataWorkingPathSupplier;
import org.infrastructurebuilder.data.IBStreamerFactory;
import org.infrastructurebuilder.util.files.IBChecksumPathType;

public abstract class AbstractIBDataMojo
extends AbstractMojo {
    @Component(hint="ibdata-working-path-supplier")
    private IBDataWorkingPathSupplier workingPathSupplier;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter
    private List<String> requiredMetadata;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="ibdata.working.directory", defaultValue="${project.build.directory}/ibdata")
    private File workingDirectory;
    @Component
    private IBDataEngine engine;
    @Component
    private IBStreamerFactory streamerFactory;
    private OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};

    public IBStreamerFactory getStreamerFactory() {
        return this.streamerFactory;
    }

    public IBDataEngine getEngine() {
        return this.engine;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this._setup();
        if (!this.skip) {
            this.getLog().info((CharSequence)("About to execute " + this.getMojo().getGoal()));
            this._execute();
        } else {
            this.getLog().warn((CharSequence)"Skipping...");
        }
    }

    public MojoExecution getMojo() {
        return this.mojo;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory.toPath();
    }

    protected abstract AbstractIBDataMavenComponent getComponent();

    protected abstract void _execute() throws MojoExecutionException, MojoFailureException;

    protected void _setup() throws MojoFailureException {
        IBDataException.cet.withTranslation(() -> Files.createDirectories(this.workingDirectory.toPath(), new FileAttribute[0]));
        this.workingPathSupplier.setPath(this.workingDirectory.toPath());
        if (this.getSession() != null) {
            this.getComponent().addConfig("<!-- UNCONFIGURABLE -->.cachePath", Paths.get(this.getSession().getLocalRepository().getBasedir(), new String[0]).resolve(".cache").resolve("download-maven-plugin").toAbsolutePath().toString());
        }
        this.getComponent().setMojoExecution(this.getMojo());
        this.getComponent().setProject(this.getProject());
        this.getComponent().setSession(this.getSession());
    }

    protected final void writeMarker(String marker, IBChecksumPathType output) throws MojoFailureException {
        try (PrintWriter w = new PrintWriter(Files.newBufferedWriter(this.getWorkingDirectory().resolve(marker + ".json"), this.options));){
            w.print(output.asJSON().toString(2));
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to write marker file", (Throwable)e);
        }
    }
}

