/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.infrastructurebuilder.data.IBDataSetFinalizer;
import org.infrastructurebuilder.data.IBDataSetFinalizerSupplier;
import org.infrastructurebuilder.data.IBStreamerFactory;
import org.infrastructurebuilder.util.config.ConfigMap;
import org.infrastructurebuilder.util.config.ConfigMapSupplier;
import org.infrastructurebuilder.util.config.DefaultConfigMapSupplier;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;

public abstract class AbstractIBDataMavenComponent {
    private final ConfigMapSupplier configMapSupplier;
    private final PathSupplier lateBoundWorkingPathSupplier;
    private final Log log;
    private final TypeToExtensionMapper t2e;
    private final Map<String, IBDataSetFinalizerSupplier<?>> allDataSetFinalizers;
    private final IBStreamerFactory streamerFactory;
    private MavenProject project;
    private MavenSession session;
    private MojoExecution mojoExecution;

    public AbstractIBDataMavenComponent(PathSupplier workingPathSupplier, Log log, TypeToExtensionMapper t2e, ConfigMapSupplier mavenCMS, Map<String, IBDataSetFinalizerSupplier<?>> allDSFinalizers, IBStreamerFactory streamerFactory) {
        this.lateBoundWorkingPathSupplier = Objects.requireNonNull(workingPathSupplier);
        this.log = Objects.requireNonNull(log);
        this.t2e = Objects.requireNonNull(t2e);
        this.configMapSupplier = Objects.requireNonNull(mavenCMS);
        this.allDataSetFinalizers = Objects.requireNonNull(allDSFinalizers);
        this.streamerFactory = Objects.requireNonNull(streamerFactory);
    }

    public final IBDataSetFinalizer<?> getDataSetFinalizerSupplier(String key, ConfigMap config) throws MojoFailureException {
        IBDataSetFinalizerSupplier<?> supplier = Optional.ofNullable(this.allDataSetFinalizers.get(key)).orElseThrow(() -> new MojoFailureException("No finalizer name " + key));
        Objects.requireNonNull(config);
        IBDataSetFinalizer k = (IBDataSetFinalizer)supplier.configure((Object)new DefaultConfigMapSupplier(this.getConfigMapSupplier()).overrideConfiguration(config)).get();
        return k;
    }

    public ConfigMapSupplier getConfigMapSupplier() {
        return new DefaultConfigMapSupplier(this.configMapSupplier);
    }

    public Log getLog() {
        return this.log;
    }

    public PathSupplier getWorkingPathSupplier() {
        return this.lateBoundWorkingPathSupplier;
    }

    public TypeToExtensionMapper getTypeToExtensionMapper() {
        return this.t2e;
    }

    public void setMojoExecution(MojoExecution mojoExecution) {
        this.mojoExecution = mojoExecution;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public Optional<MavenProject> getProject() {
        return Optional.ofNullable(this.project);
    }

    public Optional<MavenSession> getSession() {
        return Optional.ofNullable(this.session);
    }

    public Optional<MojoExecution> getMojoExecution() {
        return Optional.ofNullable(this.mojoExecution);
    }

    public void addConfig(String key, String value) {
        this.configMapSupplier.overrideValue(key, (Object)value);
    }

    public IBStreamerFactory getStreamerFactory() {
        return this.streamerFactory;
    }
}

