/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.infrastructurebuilder.data.IBDataIngester;
import org.infrastructurebuilder.data.IBDataSourceSupplier;
import org.infrastructurebuilder.data.IBDataWorkingPathSupplier;
import org.infrastructurebuilder.data.ingest.DefaultIBDataIngesterSupplier;
import org.infrastructurebuilder.data.ingest.DefaultIBDataSetIdentifier;
import org.infrastructurebuilder.data.ingest.DefaultIBDataStreamIdentifierConfigBean;
import org.infrastructurebuilder.data.ingest.IBDataIngestMavenComponent;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.util.config.MavenConfigMapSupplier;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.infrastructurebuilder.util.config.TestingPathSupplier;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBDataIngestMavenComponentTest {
    public static final Logger log = LoggerFactory.getLogger(IBDataIngestMavenComponentTest.class);
    private IBDataIngestMavenComponent dic;
    private TestingPathSupplier wps;
    private Properties properties;
    private MavenProject mp;
    private Path target;
    private Model mm;
    private MavenConfigMapSupplier cms;
    private Ingestion config;
    private IBDataIngester ingester;
    private Map<String, IBDataSourceSupplier> dataSourceSuppliers;
    private DefaultIBDataSetIdentifier ds;
    private DefaultIBDataSetIdentifier dsMulti;
    private ArrayList<DefaultIBDataStreamIdentifierConfigBean> streams;
    private DefaultIBDataStreamIdentifierConfigBean ds1;
    private String sourceURL;
    private DefaultIBDataStreamIdentifierConfigBean ds2;
    private DefaultIBDataStreamIdentifierConfigBean ds3;
    private DefaultIBDataStreamIdentifierConfigBean ds4;
    private IBDataWorkingPathSupplier lbps;

    @Before
    public void setUp() throws Exception {
        this.wps = new TestingPathSupplier();
        this.target = this.wps.getRoot();
        this.sourceURL = this.wps.getTestClasses().resolve("testfile.txt").toUri().toURL().toExternalForm();
        this.properties = new Properties();
        this.properties.setProperty("a", "b");
        this.properties.setProperty("c", "d");
        this.properties.setProperty("user.home", "override");
        this.mm = new Model();
        this.mm.setProperties(this.properties);
        Build b = new Build();
        b.setDirectory(this.target.toString());
        this.mp = new MavenProject(this.mm);
        this.mp.setBuild(b);
        Path workingPath = this.wps.get();
        this.lbps = new IBDataWorkingPathSupplier();
        this.lbps.setPath(workingPath);
        this.cms = new MavenConfigMapSupplier(this.mp, null, null);
        this.ds = new DefaultIBDataSetIdentifier();
        this.ds.setMetadata(new XmlPlexusConfiguration("metadata"));
        this.ds.setDescription("Descc");
        this.ds.setName("thename");
        this.dsMulti = new DefaultIBDataSetIdentifier();
        this.dsMulti.setMetadata(new XmlPlexusConfiguration("metadata"));
        this.dsMulti.setDescription("Multi");
        this.dsMulti.setName("theMulti");
        this.ds1 = new DefaultIBDataStreamIdentifierConfigBean();
        this.ds1.setId("temp1");
        this.ds1.setSha512("5e787c500552b5c75adb60b0cfd1ba3db2083d5a93d4d00480e16bff3d8918790e94032da47756b522b6cd458943f6a4b7f0c3dbb9ff035e7221f3a14d22e1eb");
        this.ds1.setDescription("S1 desc");
        this.ds1.setName("somename");
        this.ds1.setMimeType("text/plain");
        this.ds1.setUrl(this.sourceURL);
        this.streams = new ArrayList<DefaultIBDataStreamIdentifierConfigBean>(Arrays.asList(this.ds1));
        this.ds2 = new DefaultIBDataStreamIdentifierConfigBean();
        this.ds2.setId("temp2");
        this.ds2.setSha512("b4ab0dbcf486d0c9fa98d9f1e3f19d392201150db79196f8ec54d4d05838038d0dea917f17f09e3a302f80d39ca36cca379bf0d002c97c479694e20e0db9a50d");
        this.ds2.setDescription("S2 desc");
        this.ds2.setName("somename");
        this.ds2.setMimeType("application/pdf");
        this.ds2.setUrl("https://file-examples.com/wp-content/uploads/2017/02/file-sample_100kB.doc");
        this.ds3 = new DefaultIBDataStreamIdentifierConfigBean();
        this.ds3.setId("temp3");
        this.ds3.setSha512("09253eb87d097bdaa39f98cbbea3e6d83ee4641bca76c32c7eb1add17e9cb3117adb412d2e04ab251cca1fb19afa8b631d1e774b5dc8ae727f753fe2ffb5f288");
        this.ds3.setDescription("S3 desc");
        this.ds3.setName("somename");
        this.ds3.setMimeType("application/pdf");
        this.ds3.setUrl("https://file-examples.com/wp-content/uploads/2017/10/file-sample_150kB.pdf");
        this.ds4 = new DefaultIBDataStreamIdentifierConfigBean();
        this.ds4.setId("temp4");
        this.ds4.setSha512("5e33512e482ac4512cc8ffc3a579ee762c48f60dde3cea614b253b70fd619f129c6f0df48c8599f442b813c51e11a87dd452cf4e5bf0a8aefa195ae414cdaa41");
        this.ds4.setDescription("S4 desc");
        this.ds4.setName("somename");
        this.ds4.setMimeType("application/pdf");
        this.ds4.setUrl("https://file-examples.com/wp-content/uploads/2017/02/file_example_XLSX_5000.xlsx");
        this.config = new Ingestion();
    }

    @Ignore
    @Test
    public void testIngestFile() {
        this.ds.setStreams(this.streams);
        this.config.setDataSet(this.ds);
        DefaultIBDataIngesterSupplier s = new DefaultIBDataIngesterSupplier((PathSupplier)this.wps, () -> log);
        this.ingester = (IBDataIngester)s.get();
        this.dataSourceSuppliers = Collections.emptyMap();
    }

    @Ignore
    @Test
    public void testIngestDownload() {
        this.ds.setStreams(new ArrayList<DefaultIBDataStreamIdentifierConfigBean>(Arrays.asList(this.ds3)));
        this.config.setDataSet(this.ds);
        DefaultIBDataIngesterSupplier s = new DefaultIBDataIngesterSupplier((PathSupplier)this.wps, () -> log);
        this.ingester = (IBDataIngester)s.get();
        this.dataSourceSuppliers = Collections.emptyMap();
    }

    @Ignore
    @Test
    public void testIngestMultiDownload() throws IOException {
        this.dsMulti.setStreams(Arrays.asList(this.ds4, this.ds3));
        this.config.setDataSet(this.dsMulti);
        DefaultIBDataIngesterSupplier s = new DefaultIBDataIngesterSupplier((PathSupplier)this.wps, () -> log);
        this.ingester = (IBDataIngester)s.get();
        this.dataSourceSuppliers = Collections.emptyMap();
    }
}

