/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.infrastructurebuilder.data.AbstractIBDataMojo;
import org.infrastructurebuilder.data.ingest.IBDataIngestMavenComponent;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.util.files.IBChecksumPathType;

@Mojo(name="ingest", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresProject=true)
public class IBDataIngestMojo
extends AbstractIBDataMojo {
    @Parameter(required=true)
    private Ingestion ingest;
    @Component
    IBDataIngestMavenComponent component;

    @Override
    protected IBDataIngestMavenComponent getComponent() {
        return this.component;
    }

    @Override
    public void _execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Attempting Data Ingestion");
        Map pc = this.getPluginContext();
        if (pc.containsKey("IBDATA_TRANSFORMATION_TARGET_@3123")) {
            throw new MojoFailureException("Transformation and Ingestion cannot be performed in the same module build.");
        }
        IBChecksumPathType thePath = this.component.ingest(this.ingest);
        this.writeMarker("IBDATA_INGESTION_TARGET_@3123", thePath);
        pc.put("IBDATA_INGESTION_TARGET_@3123", thePath);
        this.setPluginContext(pc);
        this.getLog().info((CharSequence)("Data ingestion is complete with " + thePath.getPath() + " as " + thePath.getChecksum()));
    }
}

