/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.infrastructurebuilder.data.AbstractIBDataMavenComponent;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataIngester;
import org.infrastructurebuilder.data.IBDataIngesterSupplier;
import org.infrastructurebuilder.data.IBDataSetFinalizer;
import org.infrastructurebuilder.data.IBDataSetFinalizerSupplier;
import org.infrastructurebuilder.data.IBDataSetIdentifier;
import org.infrastructurebuilder.data.IBDataSource;
import org.infrastructurebuilder.data.IBDataSourceSupplier;
import org.infrastructurebuilder.data.IBStreamerFactory;
import org.infrastructurebuilder.data.archiver.IBDataLateBindingFinalizerConfigSupplier;
import org.infrastructurebuilder.data.ingest.DefaultIBDataSource;
import org.infrastructurebuilder.data.ingest.DefaultIBDataSourceSupplier;
import org.infrastructurebuilder.data.ingest.DefaultIBDataStreamIdentifierConfigBean;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.util.config.ConfigMapSupplier;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;
import org.infrastructurebuilder.util.logging.SLF4JFromMavenLogger;
import org.slf4j.Logger;

@Named(value="ingest")
public final class IBDataIngestMavenComponent
extends AbstractIBDataMavenComponent {
    private final Map<String, IBDataIngesterSupplier> allIngesters;

    @Inject
    public IBDataIngestMavenComponent(@Named(value="ibdata-working-path-supplier") PathSupplier workingPathSupplier, Log log, TypeToExtensionMapper defaultTypeToExtensionMapper, @Named(value="maven") ConfigMapSupplier mavenConfigMapSupplier, @Named(value="ibdata-config-late") IBDataLateBindingFinalizerConfigSupplier configSupplier, Map<String, IBDataIngesterSupplier> allIngesters, Map<String, IBDataSetFinalizerSupplier> allDSFinalizers, IBStreamerFactory streamerFactory) {
        super(workingPathSupplier, log, defaultTypeToExtensionMapper, mavenConfigMapSupplier, allDSFinalizers, streamerFactory);
        this.allIngesters = Objects.requireNonNull(allIngesters);
    }

    public static final SortedMap<String, IBDataSourceSupplier> mapIngestionToSourceSuppliers(Ingestion i, Log l, TypeToExtensionMapper mapper) {
        SLF4JFromMavenLogger log = new SLF4JFromMavenLogger((Object)l);
        List k = i.getDataSet().getStreams().stream().map(arg_0 -> IBDataIngestMavenComponent.lambda$mapIngestionToSourceSuppliers$1((Logger)log, mapper, arg_0)).collect(Collectors.toList());
        return new TreeMap<String, IBDataSourceSupplier>(k.stream().collect(Collectors.toMap(key -> key.getId(), Function.identity())));
    }

    public IBChecksumPathType ingest(Ingestion ingest) throws MojoFailureException {
        IBDataSetFinalizer<?> finalizer;
        Objects.requireNonNull(ingest);
        MavenProject p = this.getProject().orElseThrow(() -> new MojoFailureException("No supplied project"));
        ingest.getDataSet().injectGAV(p.getGroupId(), p.getArtifactId(), p.getVersion());
        try {
            finalizer = this.getDataSetFinalizerSupplier(ingest.getFinalizer(), ingest.getFinalizerConfig(), Optional.empty());
        }
        catch (ClassCastException e) {
            throw new MojoFailureException("Finalizer " + ingest.getFinalizer() + " was not considered viable", (Throwable)e);
        }
        IBDataIngesterSupplier i = (IBDataIngesterSupplier)Optional.ofNullable(Objects.requireNonNull(ingest).getIngester()).flatMap(j -> Optional.ofNullable(this.allIngesters.get(j))).orElseThrow(() -> new MojoFailureException("No ingester named " + ingest.getIngester()));
        List suppliers = ((IBDataIngester)i.configure((Object)this.getConfigMapSupplier()).get()).ingest((IBDataSetIdentifier)ingest.getDataSet(), IBDataIngestMavenComponent.mapIngestionToSourceSuppliers(ingest, this.getLog(), this.getTypeToExtensionMapper()));
        try {
            return finalizer.finalize(null, (Object)ingest, suppliers);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to finalize", (Throwable)e);
        }
    }

    private static /* synthetic */ DefaultIBDataSourceSupplier lambda$mapIngestionToSourceSuppliers$1(Logger log, TypeToExtensionMapper mapper, DefaultIBDataStreamIdentifierConfigBean v) {
        return new DefaultIBDataSourceSupplier(v.getTemporaryId(), (IBDataSource)new DefaultIBDataSource(log, (URL)IBDataException.cet.withReturningTranslation(() -> (URL)v.getURL().get()), Optional.ofNullable(v.getChecksum()), Optional.of(v.getMetadata()), Optional.ofNullable(v.getMimeType()), mapper));
    }
}

