/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.infrastructurebuilder.data.AbstractIBDataMojo;
import org.infrastructurebuilder.data.transform.IBDataTransformMavenComponent;
import org.infrastructurebuilder.data.transform.Transformation;
import org.infrastructurebuilder.util.files.IBChecksumPathType;

@Mojo(name="transform", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=true)
public class IBDataTransformMojo
extends AbstractIBDataMojo {
    @Parameter(required=true)
    private List<Transformation> transformations = new ArrayList<Transformation>();
    @Component
    IBDataTransformMavenComponent component;

    @Override
    protected IBDataTransformMavenComponent getComponent() {
        return this.component;
    }

    @Override
    protected void _execute() throws MojoExecutionException, MojoFailureException {
        IBChecksumPathType thePath = this.component.transform(this.transformations);
        this.getLog().debug((CharSequence)"Setting plugin context");
        Map pc = this.getPluginContext();
        pc.put("IBDATA_TRANSFORMATION_TARGET_@3123", thePath);
        this.setPluginContext(pc);
        this.getLog().debug((CharSequence)"plugin context set");
        this.getLog().info((CharSequence)("Data transformations complete with " + thePath.getPath() + " as " + thePath.getChecksum()));
    }
}

