/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.transform;

import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.infrastructurebuilder.data.AbstractIBDataMavenComponent;
import org.infrastructurebuilder.data.DefaultIBDataSet;
import org.infrastructurebuilder.data.DefaultIBDataTransformationResult;
import org.infrastructurebuilder.data.IBDataDataStreamRecordFinalizerSupplier;
import org.infrastructurebuilder.data.IBDataEngine;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataSet;
import org.infrastructurebuilder.data.IBDataSetFinalizer;
import org.infrastructurebuilder.data.IBDataSetFinalizerSupplier;
import org.infrastructurebuilder.data.IBDataStream;
import org.infrastructurebuilder.data.IBDataStreamRecordFinalizer;
import org.infrastructurebuilder.data.IBDataTransformationResult;
import org.infrastructurebuilder.data.IBDataTransformer;
import org.infrastructurebuilder.data.IBDataTransformerSupplier;
import org.infrastructurebuilder.data.IBStreamerFactory;
import org.infrastructurebuilder.data.model.DataSet;
import org.infrastructurebuilder.data.model.DataStream;
import org.infrastructurebuilder.data.transform.RecordTransformer;
import org.infrastructurebuilder.data.transform.Transformation;
import org.infrastructurebuilder.data.transform.Transformer;
import org.infrastructurebuilder.util.config.ConfigMapSupplier;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;

@Named(value="transform")
public final class IBDataTransformMavenComponent
extends AbstractIBDataMavenComponent {
    public static final BiFunction<MavenProject, Path, IBDataTransformationResult> fromProject = (p, wp) -> {
        Objects.requireNonNull(p);
        DataSet ds = new DataSet();
        ds.setUuid(UUID.randomUUID().toString());
        ds.setGroupId(p.getGroupId());
        ds.setArtifactId(p.getArtifactId());
        ds.setVersion(p.getVersion());
        ds.setDataSetName(p.getName());
        ds.setDataSetDescription(p.getDescription());
        ds.setCreationDate(new Date());
        ds.setMetadata((Object)new Xpp3Dom("metadata"));
        ds.setPath((String)IBDataException.cet.withReturningTranslation(() -> wp.toAbsolutePath().toUri().toURL().toExternalForm()));
        return new DefaultIBDataTransformationResult((IBDataSet)new DefaultIBDataSet(ds));
    };
    private final Map<String, IBDataDataStreamRecordFinalizerSupplier<?>> allRecordFinalizers;
    private final Map<String, IBDataTransformerSupplier<?>> allTransformers;
    private Function<DataStream, IBDataStream> transformToIBDataStream;
    private final IBDataEngine engine;

    @Inject
    public IBDataTransformMavenComponent(@Named(value="ibdata-working-path-supplier") PathSupplier workingPathSupplier, Log log, TypeToExtensionMapper defaultTypeToExtensionMapper, @Named(value="maven") ConfigMapSupplier mavenConfigMapSupplier, Map<String, IBDataTransformerSupplier<?>> allTransformers, Map<String, IBDataDataStreamRecordFinalizerSupplier<?>> allRecordFinalizers, Map<String, IBDataSetFinalizerSupplier> allDSFinalizers, IBStreamerFactory streamerFactory, IBDataEngine engine) {
        super(workingPathSupplier, log, defaultTypeToExtensionMapper, mavenConfigMapSupplier, allDSFinalizers, streamerFactory);
        this.allTransformers = Objects.requireNonNull(allTransformers);
        this.allRecordFinalizers = Objects.requireNonNull(allRecordFinalizers);
        this.engine = Objects.requireNonNull(engine);
        int q = this.engine.prepopulate();
    }

    public IBChecksumPathType transform(List<Transformation> transformations) throws MojoFailureException {
        Map availableStreams = this.engine.getAvailableIds().stream().map(arg_0 -> ((IBDataEngine)this.engine).fetchDataSetById(arg_0)).filter(Optional::isPresent).map(Optional::get).flatMap(s -> s.getStreamSuppliers().stream()).map(Supplier::get).collect(Collectors.toMap(k -> k.getId(), Function.identity()));
        IBChecksumPathType retVal = null;
        try {
            IBDataTransformationResult ref = null;
            for (Transformation transformation : transformations) {
                IBDataSetFinalizer<?> finalizer;
                Objects.requireNonNull(transformation);
                MavenProject theMavenProject = this.getProject().orElseThrow(() -> new IBDataException("No project available"));
                transformation.injectRequird(theMavenProject.getGroupId(), theMavenProject.getArtifactId(), theMavenProject.getVersion(), theMavenProject.getName(), theMavenProject.getDescription());
                try {
                    finalizer = this.getDataSetFinalizerSupplier(transformation.getFinalizer(), transformation.getFinalizerConfig());
                }
                catch (ClassCastException e) {
                    throw new IBDataException("Finalizer " + transformation.getFinalizer() + " was not considered viable", (Throwable)e);
                }
                ConfigMapSupplier defaults = this.getConfigMapSupplier();
                HashMap<String, Object> configuredMap = new HashMap<String, Object>();
                List sources = null;
                for (Transformer t : transformation.getTransformers()) {
                    ConfigMapSupplier tConfig = t.getConfigurationAsConfigMapSupplier(defaults);
                    IBDataTransformerSupplier ts = Optional.ofNullable(this.allTransformers.get(t.getHint())).orElseThrow(() -> new IBDataException("Transformer " + t.getHint() + " not found"));
                    if (t instanceof RecordTransformer) {
                        RecordTransformer g = (RecordTransformer)t;
                        ts = ts.withFinalizer((IBDataStreamRecordFinalizer)Optional.ofNullable(this.allRecordFinalizers.get(g.getRecordFinalizer())).orElseThrow(() -> new IBDataException("Record finalizer  " + g.getRecordFinalizer() + " not found")).config(g.getRecordFinalizerConfig(defaults)).get());
                    }
                    ts = ts.configure(t.getConfigurationAsConfigMapSupplier(tConfig));
                    configuredMap.put(t.getId(), ts.get());
                    sources = t.asMatchingStreams(availableStreams.values());
                }
                ref = fromProject.apply(theMavenProject, finalizer.getWorkingPath());
                for (Transformer t : transformation.getTransformers()) {
                    if (!((Optional)ref.get()).isPresent()) continue;
                    IBDataTransformer transformer = (IBDataTransformer)configuredMap.get(t.getId());
                    ref = transformer.transform(t, (IBDataSet)((Optional)ref.get()).get(), sources, t.isFailOnAnyError());
                }
                retVal = ((Optional)Objects.requireNonNull(ref).get()).map(r -> (IBChecksumPathType)IBDataException.cet.withReturningTranslation(() -> finalizer.finalize(r, (Object)transformation, r.getStreamSuppliers()))).orElseThrow(() -> new IBDataException("Failed to finalize.  IBDataSet unavailable from processing"));
            }
            return retVal;
        }
        catch (IBDataException e) {
            throw new MojoFailureException("Transformation failed to execute", (Throwable)e);
        }
    }
}

