/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.infrastructurebuilder.data.AbstractIBDataMavenComponent;
import org.infrastructurebuilder.data.IBDataEngine;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataWorkingPathSupplier;
import org.infrastructurebuilder.data.IBStreamerFactory;

public abstract class AbstractIBDataMojo
extends AbstractMojo {
    public static final String IBDATA_WORKING_DIRECTORY = "ibdata.working.directory";
    protected static final String INGESTION_TARGET = "IBDATA_INGESTION_TARGET_@3123";
    protected static final String TRANSFORMATION_TARGET = "IBDATA_TRANSFORMATION_TARGET_@3123";
    @Component(hint="ibdata-working-path-supplier")
    private IBDataWorkingPathSupplier workingPathSupplier;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter
    private List<String> requiredMetadata;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="ibdata.working.directory", defaultValue="${project.build.directory}/ibdata")
    private File workingDirectory;
    @Component
    private IBDataEngine engine;
    @Component
    private IBStreamerFactory streamerFactory;

    public IBStreamerFactory getStreamerFactory() {
        return this.streamerFactory;
    }

    public IBDataEngine getEngine() {
        return this.engine;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this._setup();
        if (!this.skip) {
            this.getLog().info((CharSequence)("About to execute " + this.getMojo().getGoal()));
            this._execute();
        } else {
            this.getLog().warn((CharSequence)"Skipping...");
        }
    }

    public MojoExecution getMojo() {
        return this.mojo;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    protected abstract AbstractIBDataMavenComponent getComponent();

    protected abstract void _execute() throws MojoExecutionException, MojoFailureException;

    protected void _setup() throws MojoFailureException {
        IBDataException.cet.withTranslation(() -> Files.createDirectories(this.workingDirectory.toPath(), new FileAttribute[0]));
        this.workingPathSupplier.setPath(this.workingDirectory.toPath());
        if (this.getSession() != null) {
            this.getComponent().addConfig("<!-- UNCONFIGURABLE -->.cachePath", Paths.get(this.getSession().getLocalRepository().getBasedir(), new String[0]).resolve(".cache").resolve("download-maven-plugin").toAbsolutePath().toString());
        }
        this.getComponent().setMojoExecution(this.getMojo());
        this.getComponent().setProject(this.getProject());
        this.getComponent().setSession(this.getSession());
    }
}

