/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.sisu.Typed;
import org.infrastructurebuilder.data.AbstractIBDataSetFinalizer;
import org.infrastructurebuilder.data.AbstractIBDataSetFinalizerSupplier;
import org.infrastructurebuilder.data.IBDataModelUtils;
import org.infrastructurebuilder.data.IBDataSet;
import org.infrastructurebuilder.data.IBDataSetFinalizerSupplier;
import org.infrastructurebuilder.data.IBDataStream;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.data.model.DataSet;
import org.infrastructurebuilder.util.LoggerSupplier;
import org.infrastructurebuilder.util.config.ConfigMap;
import org.infrastructurebuilder.util.config.ConfigMapSupplier;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="default-ingest")
@Typed(value={IBDataSetFinalizerSupplier.class})
public class DefaultIBDataSetIngestionFinalizerSupplier
extends AbstractIBDataSetFinalizerSupplier<Ingestion> {
    public static final String DEFAULT_INGEST = "default-ingest";
    public static final Logger logger = LoggerFactory.getLogger(DefaultIBDataSetIngestionFinalizerSupplier.class);

    @Inject
    public DefaultIBDataSetIngestionFinalizerSupplier(@Named(value="ibdata-working-path-supplier") PathSupplier wps, LoggerSupplier l, TypeToExtensionMapper t2e) {
        this((Logger)l.get(), wps, null, t2e);
    }

    private DefaultIBDataSetIngestionFinalizerSupplier(Logger logger, PathSupplier workingPath, ConfigMapSupplier cms, TypeToExtensionMapper t2e) {
        super(logger, workingPath, cms, t2e);
    }

    public DefaultIBDataSetIngestionFinalizerSupplier getConfiguredSupplier(ConfigMapSupplier cms) {
        return new DefaultIBDataSetIngestionFinalizerSupplier(this.getLog(), this.getWps(), cms, this.getTypeToExtensionMapper());
    }

    protected IngestionIBDataSetFinalizer configuredType(ConfigMapSupplier config) {
        return new IngestionIBDataSetFinalizer((ConfigMap)Objects.requireNonNull(config, "Config supplier is null").get(), (Path)this.getWps().get());
    }

    private class IngestionIBDataSetFinalizer
    extends AbstractIBDataSetFinalizer<Ingestion> {
        public IngestionIBDataSetFinalizer(ConfigMap config, Path workingPath) {
            super(config, workingPath);
        }

        public IBChecksumPathType finalize(IBDataSet dsi2, Ingestion target, List<Supplier<IBDataStream>> ibdssList) throws IOException {
            return IBDataModelUtils.forceToFinalizedPath((Date)new Date(), (Path)this.getWorkingPath(), (DataSet)target.asDataSet(), ibdssList, (TypeToExtensionMapper)DefaultIBDataSetIngestionFinalizerSupplier.this.getTypeToExtensionMapper());
        }
    }
}

