/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.infrastructurebuilder.data.DefaultIBDataStream;
import org.infrastructurebuilder.data.DefaultIBDataStreamIdentifier;
import org.infrastructurebuilder.data.DefaultIBDataStreamSupplier;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataIngester;
import org.infrastructurebuilder.data.IBDataSetIdentifier;
import org.infrastructurebuilder.data.IBDataSource;
import org.infrastructurebuilder.data.IBDataSourceSupplier;
import org.infrastructurebuilder.data.IBDataStream;
import org.infrastructurebuilder.data.IBDataStreamIdentifier;
import org.infrastructurebuilder.data.IBMetadataUtils;
import org.infrastructurebuilder.data.ingest.AbstractIBDataIngester;
import org.infrastructurebuilder.data.ingest.AbstractIBDataIngesterSupplier;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.util.LoggerSupplier;
import org.infrastructurebuilder.util.artifacts.Checksum;
import org.infrastructurebuilder.util.config.ConfigMap;
import org.infrastructurebuilder.util.config.ConfigMapSupplier;
import org.infrastructurebuilder.util.config.DefaultConfigMapSupplier;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.slf4j.Logger;
import org.w3c.dom.Document;

@Named(value="default")
public class DefaultIBDataIngesterSupplier
extends AbstractIBDataIngesterSupplier {
    public static final String NAME = "default";
    public static final String UNZIP = "unarchive";

    @Inject
    public DefaultIBDataIngesterSupplier(@Named(value="ibdata-working-path-supplier") PathSupplier wps, LoggerSupplier log) {
        this(wps, log, null);
    }

    private DefaultIBDataIngesterSupplier(PathSupplier wps, LoggerSupplier log, ConfigMapSupplier cms) {
        super(wps, log, cms);
    }

    protected final IBDataIngester configuredType(ConfigMapSupplier config) {
        return new DefaultIBDataIngester((Path)this.getWps().get(), this.getLog(), (ConfigMap)config.get());
    }

    public DefaultIBDataIngesterSupplier getConfiguredSupplier(ConfigMapSupplier config) {
        return new DefaultIBDataIngesterSupplier(this.getWps(), () -> this.getLog(), config);
    }

    static final DefaultIBDataStreamSupplier xyz(Path workingPath, IBDataSource source, IBChecksumPathType ibPathChecksumType, Date now) {
        Path localPath = ibPathChecksumType.getPath();
        String p = Objects.requireNonNull(workingPath).relativize(localPath).toString();
        Checksum c = ibPathChecksumType.getChecksum();
        UUID id = (UUID)c.asUUID().get();
        DefaultIBDataStreamIdentifier ddsi = new DefaultIBDataStreamIdentifier(id, Optional.of(source.getSourceURL()), source.getName(), source.getDescription(), ibPathChecksumType.getChecksum(), now, (Document)source.getMetadata().orElse(IBMetadataUtils.emptyDocumentSupplier.get()), ibPathChecksumType.getType(), Optional.of(p));
        return new DefaultIBDataStreamSupplier((IBDataStream)new DefaultIBDataStream((IBDataStreamIdentifier)ddsi, ibPathChecksumType));
    }

    static final Stream<Supplier<IBDataStream>> dataSourceToStreamMapper(Path workingPath, Date now, IBDataSource source) {
        List list = (List)source.get();
        return list.stream().map(ibPathChecksumType -> DefaultIBDataIngesterSupplier.xyz(workingPath, source, ibPathChecksumType, now));
    }

    public final class DefaultIBDataIngester
    extends AbstractIBDataIngester {
        private final Path cacheDirectory;
        private final boolean splitZips;

        public DefaultIBDataIngester(Path workingPath, Logger log, ConfigMap config) {
            super(workingPath, log, config);
            this.cacheDirectory = Optional.ofNullable(Objects.requireNonNull(config, "Config map not supplied").getString("<!-- UNCONFIGURABLE -->.cachePath")).map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow(() -> new IBDataException("No cache directory specified"));
            this.splitZips = Optional.ofNullable(Objects.requireNonNull(config, "Config map not supplied").getString("<!-- UNCONFIGURABLE -->.cachePath")).map(Boolean::parseBoolean).orElse(false);
        }

        public List<Supplier<IBDataStream>> ingest(Ingestion ingest, IBDataSetIdentifier dsi, SortedMap<String, IBDataSourceSupplier> dssList) {
            Objects.requireNonNull(dsi, "IBDataSetIdentifier for ingestion");
            Objects.requireNonNull(dssList, "List of IBDataSourceSupplier instances");
            Date now = new Date();
            ConfigMap over = new ConfigMap();
            over.put("Source-Target-Path", (Object)this.getWorkingPath());
            over.put("Source-Cache-Directory", (Object)this.cacheDirectory);
            over.put(DefaultIBDataIngesterSupplier.UNZIP, (Object)this.splitZips);
            ConfigMap cms = (ConfigMap)new DefaultConfigMapSupplier(this.getConfig()).overrideConfiguration(over).get();
            return dssList.values().stream().map(Supplier::get).map(ds -> ds.withAdditionalConfig(cms)).flatMap(u -> DefaultIBDataIngesterSupplier.dataSourceToStreamMapper(this.getWorkingPath(), now, u)).collect(Collectors.toList());
        }
    }
}

