/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Supplier;
import org.infrastructurebuilder.data.DefaultIBDataSet;
import org.infrastructurebuilder.data.DefaultTestingSource;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataIngester;
import org.infrastructurebuilder.data.IBDataSet;
import org.infrastructurebuilder.data.IBDataSetFinalizer;
import org.infrastructurebuilder.data.IBDataSetIdentifier;
import org.infrastructurebuilder.data.IBDataSource;
import org.infrastructurebuilder.data.IBDataSourceSupplier;
import org.infrastructurebuilder.data.IBDataStream;
import org.infrastructurebuilder.data.IBDataStreamIdentifier;
import org.infrastructurebuilder.data.ingest.AbstractIBDataSourceSupplierMapper;
import org.infrastructurebuilder.data.ingest.DefaultIBDataIngesterSupplier;
import org.infrastructurebuilder.data.ingest.DefaultIBDataSetIdentifier;
import org.infrastructurebuilder.data.ingest.DefaultIBDataSetIngestionFinalizerSupplier;
import org.infrastructurebuilder.data.ingest.IBDataSourceSupplierMapper;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.data.model.DataSet;
import org.infrastructurebuilder.data.util.files.DefaultTypeToExtensionMapper;
import org.infrastructurebuilder.util.artifacts.Checksum;
import org.infrastructurebuilder.util.config.ConfigMap;
import org.infrastructurebuilder.util.config.ConfigMapSupplier;
import org.infrastructurebuilder.util.config.DefaultConfigMapSupplier;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.infrastructurebuilder.util.config.TestingPathSupplier;
import org.infrastructurebuilder.util.files.DefaultIBChecksumPathType;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.infrastructurebuilder.util.files.TypeToExtensionMapper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIBDataIngesterSupplierTest {
    public static final Logger log = LoggerFactory.getLogger(DefaultIBDataIngesterSupplierTest.class);
    public static final TestingPathSupplier wps = new TestingPathSupplier();
    private DefaultIBDataIngesterSupplier dis;
    private ConfigMap configMap;
    private DefaultConfigMapSupplier cms;
    private IBDataIngester c;
    private SortedMap<String, IBDataSourceSupplier> dss;
    private SortedMap<String, IBDataSourceSupplier> dssFail;
    private SortedMap<String, IBDataSourceSupplier> dssPass;
    private DefaultIBDataSetIdentifier dsi;
    private Ingestion i;
    private IBDataSourceSupplierMapper dssm;
    private IBDataSourceSupplierMapper dssmFail;
    private IBDataSourceSupplierMapper dssmPass;
    private TypeToExtensionMapper t2e = new DefaultTypeToExtensionMapper();
    private IBDataSourceSupplier k;
    private DefaultIBDataSetIngestionFinalizerSupplier ibdfs;
    private IBDataSet ibdataset;
    private Date now = new Date();
    private Checksum filesDotTxtChecksum;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        wps.finalize();
    }

    @Before
    public void setUp() throws Exception {
        final Path f = wps.getTestClasses().resolve("file.txt").toAbsolutePath();
        this.filesDotTxtChecksum = new Checksum(f);
        Path cache = wps.get().toAbsolutePath();
        this.configMap = new ConfigMap();
        this.configMap.put("<!-- UNCONFIGURABLE -->.cachePath", (Object)cache.toString());
        this.cms = new DefaultConfigMapSupplier(this.configMap);
        this.ibdfs = new DefaultIBDataSetIngestionFinalizerSupplier((PathSupplier)wps, () -> log, this.t2e);
        this.ibdfs = (DefaultIBDataSetIngestionFinalizerSupplier)this.ibdfs.configure((ConfigMapSupplier)this.cms);
        this.dis = new DefaultIBDataIngesterSupplier((PathSupplier)wps, () -> log);
        this.dsi = new DefaultIBDataSetIdentifier();
        this.dsi.setDescription("desc");
        this.dsi.setName("name");
        this.dsi.setPath(f.toString());
        this.dsi.injectGAV("X", "Y", "1.0");
        this.i = new Ingestion();
        this.i.setDataSet(this.dsi);
        this.dss = new TreeMap<String, IBDataSourceSupplier>();
        this.dssFail = new TreeMap<String, IBDataSourceSupplier>();
        this.dssPass = new TreeMap<String, IBDataSourceSupplier>();
        DataSet dset = this.dsi.asDataSet();
        dset.setCreationDate(this.now);
        dset.setUuid(UUID.randomUUID().toString());
        this.ibdataset = new DefaultIBDataSet(dset);
        this.dssm = new AbstractIBDataSourceSupplierMapper(log, this.t2e){

            public IBDataSourceSupplier getSupplierFor(String temporaryId, IBDataStreamIdentifier v) {
                DefaultTestingSource ibds = new DefaultTestingSource("dummy:source"){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public List<IBChecksumPathType> get() {
                        try (InputStream source = Files.newInputStream(f, new OpenOption[0]);){
                            IBChecksumPathType reference = DefaultIBChecksumPathType.copyToDeletedOnExitTempChecksumAndPath(Optional.of(wps.get()), (String)"X", (String)"Y", (InputStream)source);
                            List<IBChecksumPathType> list = Arrays.asList(reference);
                            return list;
                        }
                        catch (IOException e) {
                            throw new IBDataException("Test failed", (Throwable)e);
                        }
                    }
                };
                return new AbstractIBDataSourceSupplierMapper.DefaultIBDataSourceSupplier((AbstractIBDataSourceSupplierMapper)this, "X", (IBDataSource)ibds);
            }

            public List<String> getHeaders() {
                return Arrays.asList("dummy:");
            }
        };
        this.dssmPass = new AbstractIBDataSourceSupplierMapper(log, this.t2e){

            public IBDataSourceSupplier getSupplierFor(String temporaryId, IBDataStreamIdentifier v) {
                DefaultTestingSource ibds = new DefaultTestingSource("dummy:source"){

                    public Optional<Checksum> getChecksum() {
                        return Optional.of(DefaultIBDataIngesterSupplierTest.this.filesDotTxtChecksum);
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public List<IBChecksumPathType> get() {
                        try (InputStream source = Files.newInputStream(f, new OpenOption[0]);){
                            IBChecksumPathType reference = DefaultIBChecksumPathType.copyToDeletedOnExitTempChecksumAndPath(Optional.of(wps.get()), (String)"X", (String)"Y", (InputStream)source);
                            List<IBChecksumPathType> list = Arrays.asList(reference);
                            return list;
                        }
                        catch (IOException e) {
                            throw new IBDataException("Test failed", (Throwable)e);
                        }
                    }
                };
                return new AbstractIBDataSourceSupplierMapper.DefaultIBDataSourceSupplier((AbstractIBDataSourceSupplierMapper)this, "X", (IBDataSource)ibds);
            }

            public List<String> getHeaders() {
                return Arrays.asList("dummy:");
            }
        };
        this.k = this.dssm.getSupplierFor(UUID.randomUUID().toString(), null);
        this.dss.put("X", this.k);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testType() {
        DefaultTestingSource ibds = new DefaultTestingSource("dummy:source");
        Assert.assertEquals((Object)"application/octet-stream", ibds.getMimeType().get());
    }

    @Test(expected=IBDataException.class)
    public void testNoCacheDirSet() {
        new DefaultIBDataIngesterSupplier((PathSupplier)wps, () -> log).configure((ConfigMapSupplier)new DefaultConfigMapSupplier()).get();
    }

    @Test
    public void testGet() throws IOException {
        IBDataSetFinalizer finalizer = (IBDataSetFinalizer)this.ibdfs.get();
        this.dis = this.dis.getConfiguredSupplier((ConfigMapSupplier)this.cms);
        Assert.assertNotNull((Object)this.dis);
        this.c = ((IBDataIngester)this.dis.get()).configure(this.configMap);
        List val = this.c.ingest(this.i, (IBDataSetIdentifier)this.dsi, this.dss);
        IBChecksumPathType finalized = finalizer.finalize(this.ibdataset, (Object)this.i, val);
        Assert.assertTrue((boolean)Files.isDirectory(finalized.getPath(), new LinkOption[0]));
        Assert.assertNotNull((Object)val);
        Assert.assertEquals((long)1L, (long)val.size());
        IBDataStream q = (IBDataStream)((Supplier)val.get(0)).get();
        Assert.assertEquals((Object)"text/plain", (Object)q.getMimeType());
    }

    @Test
    public void testPassChecksum() throws IOException {
        this.dssPass.put("X", this.dssmPass.getSupplierFor(UUID.randomUUID().toString(), null));
        this.dis = this.dis.getConfiguredSupplier((ConfigMapSupplier)this.cms);
        Assert.assertNotNull((Object)this.dis);
        this.c = ((IBDataIngester)this.dis.get()).configure(this.configMap);
        List val = this.c.ingest(this.i, (IBDataSetIdentifier)this.dsi, this.dssPass);
        Assert.assertNotNull((Object)val);
    }
}

