/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.ingest;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.infrastructurebuilder.data.DefaultIBDataStream;
import org.infrastructurebuilder.data.DefaultIBDataStreamIdentifier;
import org.infrastructurebuilder.data.DefaultIBDataStreamSupplier;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.IBDataIngester;
import org.infrastructurebuilder.data.IBDataSetIdentifier;
import org.infrastructurebuilder.data.IBDataSource;
import org.infrastructurebuilder.data.IBDataSourceSupplier;
import org.infrastructurebuilder.data.IBDataStream;
import org.infrastructurebuilder.data.IBDataStreamIdentifier;
import org.infrastructurebuilder.data.ingest.AbstractIBDataIngester;
import org.infrastructurebuilder.data.ingest.AbstractIBDataIngesterSupplier;
import org.infrastructurebuilder.data.ingest.Ingestion;
import org.infrastructurebuilder.util.LoggerSupplier;
import org.infrastructurebuilder.util.config.ConfigMap;
import org.infrastructurebuilder.util.config.ConfigMapSupplier;
import org.infrastructurebuilder.util.config.DefaultConfigMapSupplier;
import org.infrastructurebuilder.util.config.PathSupplier;
import org.slf4j.Logger;

@Named(value="default")
public class DefaultIBDataIngesterSupplier
extends AbstractIBDataIngesterSupplier {
    private Path cacheDirectory;

    @Inject
    public DefaultIBDataIngesterSupplier(@Named(value="ibdata-working-path-supplier") PathSupplier wps, LoggerSupplier log) {
        this(wps, log, null, null);
    }

    private DefaultIBDataIngesterSupplier(PathSupplier wps, LoggerSupplier log, ConfigMapSupplier cms, Path cacheDirectory) {
        super(wps, log, cms);
        this.cacheDirectory = cacheDirectory;
    }

    protected final IBDataIngester configuredType(ConfigMapSupplier config) {
        return new DefaultIBDataIngester((Path)this.getWps().get(), this.getLog(), (ConfigMap)config.get(), this.cacheDirectory, false);
    }

    public DefaultIBDataIngesterSupplier getConfiguredSupplier(ConfigMapSupplier config) {
        Optional<String> configItem = Optional.ofNullable(((ConfigMap)Objects.requireNonNull(config, "Config map not supplied").get()).getString("<!-- UNCONFIGURABLE -->.cachePath"));
        Path cacheConfig = configItem.map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow(() -> new IBDataException("No cache directory specified"));
        return new DefaultIBDataIngesterSupplier(this.getWps(), () -> this.getLog(), config, cacheConfig);
    }

    public final class DefaultIBDataIngester
    extends AbstractIBDataIngester {
        private final Path cacheDirectory;

        public DefaultIBDataIngester(Path workingPath, Logger log, ConfigMap config, Path cacheDirectory, boolean splitZipFiles) {
            super(workingPath, log, config);
            this.cacheDirectory = cacheDirectory;
        }

        public List<Supplier<IBDataStream>> ingest(Ingestion ingest, IBDataSetIdentifier dsi, SortedMap<String, IBDataSourceSupplier> dssList) {
            Objects.requireNonNull(dsi);
            Date now = new Date();
            ConfigMap over = new ConfigMap();
            over.put("Source-Target-Path", (Object)this.getWorkingPath());
            over.put("Source-Cache-Directory", (Object)this.cacheDirectory);
            ConfigMapSupplier cms = new DefaultConfigMapSupplier(this.getConfig()).overrideConfiguration(over);
            List<Supplier<IBDataStream>> ibdssList = Objects.requireNonNull(dssList).values().stream().map(dss -> {
                IBDataSource source = ((IBDataSource)dss.get()).withAdditionalConfig((ConfigMap)cms.get());
                return ((Optional)source.get()).map(thisOne -> {
                    Path localPath = thisOne.getPath();
                    Optional<String> p = Optional.of(this.getWorkingPath().relativize(localPath).toString());
                    source.getChecksum().ifPresent(checksum -> {
                        if (!thisOne.getChecksum().equals(checksum)) {
                            throw new IBDataException("Read stream failed to match expected checksum " + checksum);
                        }
                    });
                    DefaultIBDataStreamIdentifier ddsi = new DefaultIBDataStreamIdentifier(source, now, p);
                    return new DefaultIBDataStreamSupplier((IBDataStream)new DefaultIBDataStream((IBDataStreamIdentifier)ddsi, thisOne));
                });
            }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return ibdssList;
        }
    }
}

