/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.archiver;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.infrastructurebuilder.data.IBDataException;
import org.infrastructurebuilder.data.archiver.IBDataLateBindingFinalizerConfigSupplier;
import org.infrastructurebuilder.util.LoggerSupplier;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.slf4j.Logger;

@Named(value="default-ibdata")
public class DefaultIBDataMavenArchiveFinalizer
extends AbstractArchiveFinalizer
implements ArchiveFinalizer {
    public static final String NAME = "default-ibdata";
    private IBDataLateBindingFinalizerConfigSupplier configSupplier;
    private Logger logger;
    private IBChecksumPathType config = null;
    private List vFiles = Collections.emptyList();

    @Inject
    public DefaultIBDataMavenArchiveFinalizer(LoggerSupplier logger, IBDataLateBindingFinalizerConfigSupplier cffconfigSupplier) {
        this.logger = (Logger)Objects.requireNonNull(logger).get();
        this.configSupplier = Objects.requireNonNull(cffconfigSupplier);
    }

    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        this.logger.info("Finalizing " + (Object)((Object)this) + " with " + archiver);
        this.config = (IBChecksumPathType)Optional.ofNullable(this.configSupplier.get()).orElseThrow(() -> new ArchiverException("No finalizer config available"));
        this.vFiles = new ArrayList();
        ((DirectoryStream)IBDataException.cet.withReturningTranslation(() -> Files.newDirectoryStream(this.config.getPath()))).forEach(this.vFiles::add);
        DefaultFileSet fs = new DefaultFileSet(this.config.getPath().toFile());
        archiver.addFileSet((FileSet)fs);
    }

    public void finalizeArchiveExtraction(UnArchiver unarchiver) throws ArchiverException {
        super.finalizeArchiveExtraction(unarchiver);
    }

    public List getVirtualFiles() {
        this.logger.info("Getting " + this.vFiles.size() + " virtual files");
        return this.vFiles;
    }
}

