/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.archiver;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.archiver.AbstractArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.infrastructurebuilder.data.archiver.IBDataLateBindingFinalizerConfigSupplier;
import org.infrastructurebuilder.util.LoggerSupplier;
import org.infrastructurebuilder.util.files.IBChecksumPathType;
import org.slf4j.Logger;

@Named
public class DefaultIBDataMavenStreamFinalizer
extends AbstractArchiveFinalizer
implements ArchiveFinalizer {
    private final IBDataLateBindingFinalizerConfigSupplier configSupplier;
    private IBChecksumPathType config = null;
    private final Logger logger;

    @Inject
    public DefaultIBDataMavenStreamFinalizer(LoggerSupplier logger, IBDataLateBindingFinalizerConfigSupplier cusplier) {
        this.configSupplier = Objects.requireNonNull(cusplier);
        this.logger = (Logger)Objects.requireNonNull(logger).get();
    }

    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        this.config = (IBChecksumPathType)Optional.ofNullable(this.configSupplier.get()).orElseThrow(() -> new ArchiverException("No config supplied for Stream finalizer"));
    }

    public void finalizeArchiveExtraction(UnArchiver unarchiver) throws ArchiverException {
    }

    public List getVirtualFiles() {
        return Collections.emptyList();
    }
}

