/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.archiver;

import java.util.List;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.infrastructurebuilder.data.archiver.AbstractIBDataConfigTestSetup;
import org.infrastructurebuilder.data.archiver.DefaultIBDataMavenStreamFinalizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIBDataMavenStreamFinalizerTest
extends AbstractIBDataConfigTestSetup {
    public static final Logger l = LoggerFactory.getLogger(DefaultIBDataMavenStreamFinalizerTest.class);

    @Before
    public void setup() {
        super.abstractSetup();
        this.logger = l;
    }

    @Test
    public void testDataStreamArchiveFinalizer() {
        Assert.assertNotNull((String)"Existential", (Object)new DefaultIBDataMavenStreamFinalizer(() -> this.logger, this.c));
    }

    @Test
    public void testDataStreamArchiveFinalizerCreation() {
        DefaultIBDataMavenStreamFinalizer sf = new DefaultIBDataMavenStreamFinalizer(() -> this.logger, this.c);
        sf.finalizeArchiveCreation((Archiver)new JarArchiver());
    }

    @Test(expected=ArchiverException.class)
    public void testDataStreamArchiveFinalizerCreationNullConfig() {
        this.c.setT(null);
        DefaultIBDataMavenStreamFinalizer sf = new DefaultIBDataMavenStreamFinalizer(() -> this.logger, this.c);
        sf.finalizeArchiveCreation((Archiver)new JarArchiver());
    }

    @Test
    public void testFinalizeArchiveExtractionUnArchiver() {
        new DefaultIBDataMavenStreamFinalizer(() -> this.logger, this.c).finalizeArchiveExtraction((UnArchiver)new ZipUnArchiver());
    }

    @Test
    public void testGetVirtualFiles() {
        List l = new DefaultIBDataMavenStreamFinalizer(() -> this.logger, this.c).getVirtualFiles();
        Assert.assertEquals((String)"none", (long)0L, (long)l.size());
    }
}

