/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.data.archiver;

import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.infrastructurebuilder.data.archiver.AbstractIBDataConfigTestSetup;
import org.infrastructurebuilder.data.archiver.DefaultIBDataMavenArchiveFinalizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIBDataMavenArchiveFinalizerTest
extends AbstractIBDataConfigTestSetup {
    private Logger l = LoggerFactory.getLogger(DefaultIBDataMavenArchiveFinalizerTest.class);

    @Before
    public void setup() {
        super.abstractSetup();
        this.logger = this.l;
    }

    @Test
    public void testFinalizeArchiveCreationArchiver() {
        DefaultIBDataMavenArchiveFinalizer f = new DefaultIBDataMavenArchiveFinalizer(() -> this.logger, this.c);
        f.finalizeArchiveCreation((Archiver)new JarArchiver());
    }

    @Test(expected=ArchiverException.class)
    public void testNullArchiverConfig() {
        this.c.setT(null);
        DefaultIBDataMavenArchiveFinalizer f = new DefaultIBDataMavenArchiveFinalizer(() -> this.logger, this.c);
        f.finalizeArchiveCreation((Archiver)new JarArchiver());
    }

    @Test
    public void testFinalizeArchiveExtractionUnArchiver() {
        DefaultIBDataMavenArchiveFinalizer f = new DefaultIBDataMavenArchiveFinalizer(() -> this.logger, this.c);
        f.finalizeArchiveExtraction((UnArchiver)new ZipUnArchiver());
    }

    @Test
    public void testGetVirtualFiles() {
        DefaultIBDataMavenArchiveFinalizer f = new DefaultIBDataMavenArchiveFinalizer(() -> this.logger, this.c);
        Assert.assertEquals((long)0L, (long)f.getVirtualFiles().size());
    }
}

