/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.batched;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.infobip.lib.popout.FileQueue;
import org.infobip.lib.popout.batched.BatchedFileQueue;

public class BatchedFileQueueBuilder<T>
extends FileQueue.Builder<BatchedFileQueueBuilder<T>, T> {
    public static final int MEMORY_ELEMENTS_MIN = 1;
    private long batchSize;

    public BatchedFileQueueBuilder<T> batchSize(int value) {
        this.batchSize = value;
        return this;
    }

    @Override
    protected FileQueue<T> createQueue() {
        return new BatchedFileQueue(this);
    }

    @Override
    protected void validateAndSetDefaults() {
        super.validateAndSetDefaults();
        if (this.batchSize <= 1L) {
            throw new IllegalArgumentException("batchSize - must be greater than 1");
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public long getBatchSize() {
        return this.batchSize;
    }
}

