/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.backend;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.ReadBytesUtils;
import io.appulse.utils.WriteBytesUtils;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import lombok.NonNull;
import org.infobip.lib.popout.WalFilesConfig;
import org.infobip.lib.popout.backend.FilesManager;
import org.infobip.lib.popout.backend.WalContent;

class WalFiles
implements Iterable<WalContent> {
    private final FilesManager files;
    private final int maxCount;

    WalFiles(@NonNull String queueName, @NonNull Boolean restoreFromDisk, @NonNull WalFilesConfig config) {
        if (queueName == null) {
            throw new NullPointerException("queueName is marked @NonNull but is null");
        }
        if (restoreFromDisk == null) {
            throw new NullPointerException("restoreFromDisk is marked @NonNull but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked @NonNull but is null");
        }
        this.files = FilesManager.builder().folder(config.getFolder()).prefix(queueName + '-').suffix(".wal").build();
        if (!restoreFromDisk.booleanValue()) {
            this.files.clear();
        }
        this.maxCount = config.getMaxCount();
    }

    void write(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        Path file = this.files.createNextFile();
        WriteBytesUtils.write((Path)file, (Bytes)buffer);
    }

    int pollTo(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        Path file = this.files.poll();
        int readed = this.readTo(file, buffer);
        if (readed > 0) {
            this.files.remove(file);
        }
        return readed;
    }

    int peakTo(@NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        return this.readTo(this.files.peek(), buffer);
    }

    boolean isLimitExceeded() {
        return this.files.getFilesFromQueue().size() > this.maxCount;
    }

    Collection<Path> getFiles() {
        return this.files.getFilesFromQueue();
    }

    long diskSize() {
        long result = 0L;
        for (Path file : this.getFiles()) {
            result += Files.size(file);
        }
        return result;
    }

    void remove(Collection<Path> paths) {
        this.files.remove(paths);
    }

    @Override
    public Iterator<WalContent> iterator() {
        return new WalFilesIterator();
    }

    private int readTo(Path file, Bytes buffer) {
        if (file == null) {
            return 0;
        }
        int size = (int)Files.size(file);
        if (!buffer.isWritable(size)) {
            int newCapacity = buffer.writerIndex() + size;
            buffer.capacity(newCapacity);
        }
        return ReadBytesUtils.read((Path)file, (Bytes)buffer);
    }

    @SuppressFBWarnings(justification="generated code")
    public static WalFilesBuilder builder() {
        return new WalFilesBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public static class WalFilesBuilder {
        @SuppressFBWarnings(justification="generated code")
        private String queueName;
        @SuppressFBWarnings(justification="generated code")
        private Boolean restoreFromDisk;
        @SuppressFBWarnings(justification="generated code")
        private WalFilesConfig config;

        @SuppressFBWarnings(justification="generated code")
        WalFilesBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public WalFilesBuilder queueName(@NonNull String queueName) {
            if (queueName == null) {
                throw new NullPointerException("queueName is marked @NonNull but is null");
            }
            this.queueName = queueName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WalFilesBuilder restoreFromDisk(@NonNull Boolean restoreFromDisk) {
            if (restoreFromDisk == null) {
                throw new NullPointerException("restoreFromDisk is marked @NonNull but is null");
            }
            this.restoreFromDisk = restoreFromDisk;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WalFilesBuilder config(@NonNull WalFilesConfig config) {
            if (config == null) {
                throw new NullPointerException("config is marked @NonNull but is null");
            }
            this.config = config;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public WalFiles build() {
            return new WalFiles(this.queueName, this.restoreFromDisk, this.config);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "WalFiles.WalFilesBuilder(queueName=" + this.queueName + ", restoreFromDisk=" + this.restoreFromDisk + ", config=" + this.config + ")";
        }
    }

    private class WalFilesIterator
    implements Iterator<WalContent> {
        private final Iterator<Path> paths;
        private WalContent lastReturned;
        private WalContent next;

        private WalFilesIterator() {
            this.paths = WalFiles.this.files.getFilesFromQueue().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (!this.paths.hasNext()) {
                return false;
            }
            Path path = this.paths.next();
            this.next = WalContent.builder().file(path).offset(0L).length((int)Files.size(path)).build();
            return true;
        }

        @Override
        public WalContent next() {
            if (this.next != null || this.hasNext()) {
                this.lastReturned = this.next;
                this.next = null;
                return this.lastReturned;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.paths.remove();
            Files.deleteIfExists(this.lastReturned.getFile());
            this.lastReturned = null;
        }
    }
}

