/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.backend;

import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.infobip.lib.popout.backend.RecordHeader;
import org.infobip.lib.popout.backend.WalContent;

class CompressedFileIteratorSingleFile
implements Iterator<WalContent>,
AutoCloseable {
    private Path file;
    private FileChannel channel;
    private RecordHeader header;
    private WalContent lastReturned;
    private WalContent next;

    CompressedFileIteratorSingleFile() {
    }

    void init(Path path) {
        if (this.channel != null) {
            this.close();
        }
        this.file = path;
        this.channel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE);
        if (this.header == null) {
            this.header = new RecordHeader();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.channel == null) {
            return false;
        }
        if (this.next != null) {
            return true;
        }
        while (true) {
            this.header.readFrom(this.channel);
            if (this.header.isEnd()) {
                return false;
            }
            if (this.header.isRecord()) break;
            if (!this.header.isJump()) continue;
            long newPosition = this.header.getValue();
            this.channel.position(newPosition);
        }
        this.next = WalContent.builder().file(this.file).offset(this.channel.position()).length(this.header.getLength()).build();
        long nextHeaderPosition = this.channel.position() + (long)this.header.getLength();
        this.channel.position(nextHeaderPosition);
        return true;
    }

    @Override
    public WalContent next() {
        if (this.next != null || this.hasNext()) {
            this.lastReturned = this.next;
            this.next = null;
            return this.lastReturned;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        long oldHeaderStartPosition = this.lastReturned.getOffset() - 9L;
        this.header.writeJump(this.channel, oldHeaderStartPosition, this.channel.position());
        this.lastReturned = null;
    }

    @Override
    public void close() throws Exception {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }
}

