/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.writer;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import lombok.NonNull;
import org.infobip.lib.popout.util.ReflectionUtils;
import org.infobip.lib.popout.writer.FileWriter;

public class MmapFileWriter
implements FileWriter {
    private final Path path;
    private final FileChannel channel;
    private final int bufferSize;
    private MappedByteBuffer buffer;
    private long offset;
    private long limit;

    public MmapFileWriter(@NonNull Path path, Integer bufferSize) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.bufferSize = Optional.ofNullable(bufferSize).orElse(8192);
        this.channel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
    }

    @Override
    public long currentFileSize() {
        this.trim();
        return this.channel.size();
    }

    @Override
    public long position() {
        return this.offset + (long)Optional.ofNullable(this.buffer).map(Buffer::position).orElse(0).intValue();
    }

    @Override
    public void position(long newPosition) {
        this.offset = newPosition;
        this.closeBuffer();
        this.buffer = null;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public void write(byte[] bytes) {
        byte[] toWrite = ByteBuffer.allocate(4 + bytes.length).putInt(bytes.length).put(bytes).array();
        if (this.buffer == null || this.buffer.remaining() < toWrite.length) {
            this.buffer = this.createMappedByteBuffer();
        }
        this.buffer.put(toWrite);
        this.limit = Math.max(this.limit, this.position());
    }

    @Override
    public void trim() {
        this.offset = this.position();
        this.closeBuffer();
        this.channel.truncate(this.limit);
    }

    @Override
    public void close() throws IOException {
        this.trim();
        this.channel.close();
    }

    private MappedByteBuffer createMappedByteBuffer() {
        if (this.buffer != null) {
            this.offset = this.position();
            this.closeBuffer();
        }
        return this.channel.map(FileChannel.MapMode.READ_WRITE, this.offset, this.bufferSize);
    }

    private void closeBuffer() {
        if (this.buffer == null) {
            return;
        }
        ReflectionUtils.getFieldValueFrom(this.buffer, "cleaner").map(it -> ReflectionUtils.invokeMethodOf(it, "clean", new Object[0]));
        this.buffer = null;
    }

    public static MmapFileWriterBuilder builder() {
        return new MmapFileWriterBuilder();
    }

    public static class MmapFileWriterBuilder {
        private Path path;
        private Integer bufferSize;

        MmapFileWriterBuilder() {
        }

        public MmapFileWriterBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public MmapFileWriterBuilder bufferSize(Integer bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public MmapFileWriter build() {
            return new MmapFileWriter(this.path, this.bufferSize);
        }

        public String toString() {
            return "MmapFileWriter.MmapFileWriterBuilder(path=" + this.path + ", bufferSize=" + this.bufferSize + ")";
        }
    }
}

