/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.util;

import lombok.NonNull;

public final class FilePattern {
    @NonNull
    private final String prefix;
    @NonNull
    private final String postfix;

    public static FilePattern from(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        int index = string.indexOf(35);
        if (index == -1) {
            String message = "Invalid file pattern '" + string + "'. It doesn't have index char '#'";
            throw new IllegalArgumentException(message);
        }
        return new FilePattern(string.substring(0, index), string.substring(index + 1));
    }

    public String getFileNameWith(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must be greater or equal zero, current is " + index);
        }
        return this.prefix + index + this.postfix;
    }

    public boolean matches(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return str.length() > this.prefix.length() + this.postfix.length() && str.startsWith(this.prefix) && str.endsWith(this.postfix);
    }

    public int extractIndex(String fileName) {
        if (!this.matches(fileName)) {
            throw new IllegalArgumentException("File name '" + fileName + "' doesn't match the pattern");
        }
        String index = fileName.substring(this.prefix.length(), fileName.length() - this.postfix.length());
        return Integer.parseInt(index);
    }

    @NonNull
    public String getPrefix() {
        return this.prefix;
    }

    @NonNull
    public String getPostfix() {
        return this.postfix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilePattern)) {
            return false;
        }
        FilePattern other = (FilePattern)o;
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$postfix = this.getPostfix();
        String other$postfix = other.getPostfix();
        return !(this$postfix == null ? other$postfix != null : !this$postfix.equals(other$postfix));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $postfix = this.getPostfix();
        result = result * 59 + ($postfix == null ? 43 : $postfix.hashCode());
        return result;
    }

    public String toString() {
        return "FilePattern(prefix=" + this.getPrefix() + ", postfix=" + this.getPostfix() + ")";
    }

    public FilePattern(@NonNull String prefix, @NonNull String postfix) {
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        if (postfix == null) {
            throw new NullPointerException("postfix");
        }
        this.prefix = prefix;
        this.postfix = postfix;
    }
}

