/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.reader;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import lombok.NonNull;
import org.infobip.lib.popout.reader.FileReader;
import org.infobip.lib.popout.util.ReflectionUtils;

public final class MmapFileReader
implements FileReader {
    private final Path path;
    private final FileChannel channel;
    private final int bufferSize;
    private MappedByteBuffer buffer;
    private long offset;

    public MmapFileReader(@NonNull Path path, Integer bufferSize) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.bufferSize = Optional.ofNullable(bufferSize).orElse(8192);
        this.channel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ);
    }

    @Override
    public long currentFileSize() {
        return this.channel.size();
    }

    @Override
    public long position() {
        return this.offset + (long)Optional.ofNullable(this.buffer).map(Buffer::position).orElse(0).intValue();
    }

    @Override
    public boolean hasNext() {
        return Optional.ofNullable(this.buffer).map(Buffer::hasRemaining).orElse(false) != false || this.currentFileSize() > this.position();
    }

    @Override
    public Optional<byte[]> next() {
        return this.readInt().flatMap(this::read);
    }

    @Override
    public void position(long newPosition) {
        this.offset = newPosition;
        this.closeBuffer();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        this.closeBuffer();
        this.channel.close();
    }

    private Optional<Integer> readInt() {
        return this.read(4).map(ByteBuffer::wrap).map(ByteBuffer::getInt).filter(it -> it > 0);
    }

    private Optional<byte[]> read(int length) {
        if (this.buffer == null || this.buffer.remaining() < length) {
            this.buffer = this.createMappedByteBuffer();
            if (this.buffer.remaining() < length) {
                return Optional.empty();
            }
        }
        byte[] result = new byte[length];
        this.buffer.get(result);
        return Optional.of(result);
    }

    private MappedByteBuffer createMappedByteBuffer() {
        if (this.buffer != null) {
            this.offset = this.position();
            this.closeBuffer();
        }
        long limit = Math.min((long)this.bufferSize, Files.size(this.path) - this.offset);
        return this.channel.map(FileChannel.MapMode.READ_ONLY, this.offset, limit);
    }

    private void closeBuffer() {
        if (this.buffer == null) {
            return;
        }
        ReflectionUtils.getFieldValueFrom(this.buffer, "cleaner").map(it -> ReflectionUtils.invokeMethodOf(it, "clean", new Object[0]));
        this.buffer = null;
    }

    public static MmapFileReaderBuilder builder() {
        return new MmapFileReaderBuilder();
    }

    public static class MmapFileReaderBuilder {
        private Path path;
        private Integer bufferSize;

        MmapFileReaderBuilder() {
        }

        public MmapFileReaderBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public MmapFileReaderBuilder bufferSize(Integer bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public MmapFileReader build() {
            return new MmapFileReader(this.path, this.bufferSize);
        }

        public String toString() {
            return "MmapFileReader.MmapFileReaderBuilder(path=" + this.path + ", bufferSize=" + this.bufferSize + ")";
        }
    }
}

