/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.reader;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import lombok.NonNull;
import org.infobip.lib.popout.MetadataFile;
import org.infobip.lib.popout.reader.Deserializer;
import org.infobip.lib.popout.reader.FileReader;
import org.infobip.lib.popout.util.FilePattern;

public final class FolderReader<T>
implements Closeable {
    @NonNull
    private final Path folder;
    @NonNull
    private final FilePattern filePattern;
    @NonNull
    private final Function<Path, FileReader> createReader;
    @NonNull
    private final Deserializer<T> deserializer;
    private final AtomicReference<Object> lazyCounter = new AtomicReference();
    private FileReader currentFileReader;
    private T peek;

    public FolderReader<T> init(@NonNull MetadataFile.Position position) {
        if (position == null) {
            throw new NullPointerException("position");
        }
        this.getExistingFile(position.getIndex()).map(this.createReader::apply).ifPresent(it -> {
            this.currentFileReader = it;
            this.currentFileReader.position(position.getOffset());
            this.getLazyCounter().set(position.getIndex() + 1);
        });
        return this;
    }

    public Optional<T> readNext() {
        try {
            Optional<T> optional = this.peek();
            return optional;
        }
        finally {
            this.peek = null;
            this.checkCurrentFileReader();
        }
    }

    public Optional<T> peek() {
        if (this.peek != null) {
            return Optional.of(this.peek);
        }
        this.checkCurrentFileReader();
        if (this.currentFileReader == null) {
            return Optional.empty();
        }
        return ((Optional)this.currentFileReader.next()).map(this.deserializer::deserialize).map(it -> {
            this.peek = it;
            return this.peek;
        });
    }

    public int getCurrentFileIndex() {
        int fileIndex = this.getLazyCounter().get() - 1;
        return Math.max(fileIndex, 0);
    }

    public long getCurrentPosition() {
        return Optional.ofNullable(this.currentFileReader).map(FileReader::position).orElse(0L);
    }

    @Override
    public void close() throws IOException {
        if (this.currentFileReader != null) {
            this.currentFileReader.close();
        }
    }

    private void checkCurrentFileReader() {
        if (this.currentFileReader != null && this.currentFileReader.hasNext()) {
            return;
        }
        if (this.currentFileReader != null) {
            this.currentFileReader.close();
            Files.deleteIfExists(this.currentFileReader.getPath());
        }
        this.currentFileReader = this.nextFile().map(this.createReader::apply).orElse(null);
    }

    private Optional<Path> nextFile() {
        int index = this.getLazyCounter().getAndIncrement();
        Optional<Path> optional = this.getExistingFile(index);
        if (optional.isPresent()) {
            return optional;
        }
        int newIndex = this.getLazyCounter().updateAndGet(current -> this.tryToFindNextIndex().orElse(index));
        return this.getExistingFile(newIndex);
    }

    private Optional<Path> getExistingFile(int index) {
        String name = this.filePattern.getFileNameWith(index);
        return Optional.of(this.folder.resolve(name)).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    private AtomicInteger initLazyCounter() {
        return this.tryToFindNextIndex().map(AtomicInteger::new).orElse(new AtomicInteger(1));
    }

    private Optional<Integer> tryToFindNextIndex() {
        return Files.list(this.folder).map(Path::getFileName).map(Path::toString).filter(this.filePattern::matches).map(this.filePattern::extractIndex).min(Integer::compare);
    }

    FolderReader(@NonNull Path folder, @NonNull FilePattern filePattern, @NonNull Function<Path, FileReader> createReader, @NonNull Deserializer<T> deserializer, FileReader currentFileReader, T peek) {
        if (folder == null) {
            throw new NullPointerException("folder");
        }
        if (filePattern == null) {
            throw new NullPointerException("filePattern");
        }
        if (createReader == null) {
            throw new NullPointerException("createReader");
        }
        if (deserializer == null) {
            throw new NullPointerException("deserializer");
        }
        this.folder = folder;
        this.filePattern = filePattern;
        this.createReader = createReader;
        this.deserializer = deserializer;
        this.currentFileReader = currentFileReader;
        this.peek = peek;
    }

    public static <T> FolderReaderBuilder<T> builder() {
        return new FolderReaderBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicInteger getLazyCounter() {
        Object value = this.lazyCounter.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.lazyCounter;
            synchronized (atomicReference) {
                value = this.lazyCounter.get();
                if (value == null) {
                    AtomicInteger actualValue = this.initLazyCounter();
                    value = actualValue == null ? this.lazyCounter : actualValue;
                    this.lazyCounter.set(value);
                }
            }
        }
        return (AtomicInteger)(value == this.lazyCounter ? null : value);
    }

    public static class FolderReaderBuilder<T> {
        private Path folder;
        private FilePattern filePattern;
        private Function<Path, FileReader> createReader;
        private Deserializer<T> deserializer;
        private FileReader currentFileReader;
        private T peek;

        FolderReaderBuilder() {
        }

        public FolderReaderBuilder<T> folder(Path folder) {
            this.folder = folder;
            return this;
        }

        public FolderReaderBuilder<T> filePattern(FilePattern filePattern) {
            this.filePattern = filePattern;
            return this;
        }

        public FolderReaderBuilder<T> createReader(Function<Path, FileReader> createReader) {
            this.createReader = createReader;
            return this;
        }

        public FolderReaderBuilder<T> deserializer(Deserializer<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public FolderReaderBuilder<T> currentFileReader(FileReader currentFileReader) {
            this.currentFileReader = currentFileReader;
            return this;
        }

        public FolderReaderBuilder<T> peek(T peek) {
            this.peek = peek;
            return this;
        }

        public FolderReader<T> build() {
            return new FolderReader<T>(this.folder, this.filePattern, this.createReader, this.deserializer, this.currentFileReader, this.peek);
        }

        public String toString() {
            return "FolderReader.FolderReaderBuilder(folder=" + this.folder + ", filePattern=" + this.filePattern + ", createReader=" + this.createReader + ", deserializer=" + this.deserializer + ", currentFileReader=" + this.currentFileReader + ", peek=" + this.peek + ")";
        }
    }
}

