/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import lombok.NonNull;
import org.infobip.lib.popout.FileQueueBuilder;
import org.infobip.lib.popout.MetadataFile;
import org.infobip.lib.popout.reader.FolderReader;
import org.infobip.lib.popout.writer.FolderWriter;

public class FileQueue<T>
extends AbstractQueue<T>
implements Closeable {
    @NonNull
    private final MetadataFile metadata;
    @NonNull
    private final FolderWriter<T> writer;
    @NonNull
    private final FolderReader<T> reader;

    public static <V> FileQueueBuilder<V> in(String folder) {
        Path path = Paths.get(folder, new String[0]);
        return FileQueue.in(path);
    }

    public static <V> FileQueueBuilder<V> in(Path folder) {
        return new FileQueueBuilder(folder);
    }

    @Override
    public Iterator<T> iterator() {
        return new QueueIterator();
    }

    @Override
    public int size() {
        return (int)this.longSize();
    }

    public long longSize() {
        return this.metadata.getElements();
    }

    @Override
    public boolean offer(@NonNull T element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.writer.writeNext(element);
        this.metadata.moveTail(this.writer.getCurrentFileIndex(), this.writer.getCurrentPosition());
        return true;
    }

    @Override
    public T poll() {
        T result = this.reader.readNext().orElse(null);
        if (result != null) {
            this.metadata.moveHead(this.reader.getCurrentFileIndex(), this.reader.getCurrentPosition());
        }
        return result;
    }

    @Override
    public T peek() {
        return this.reader.peek().orElse(null);
    }

    @Override
    public void close() throws IOException {
        this.metadata.close();
        this.writer.close();
        this.reader.close();
    }

    FileQueue(@NonNull MetadataFile metadata, @NonNull FolderWriter<T> writer, @NonNull FolderReader<T> reader) {
        if (metadata == null) {
            throw new NullPointerException("metadata");
        }
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        this.metadata = metadata;
        this.writer = writer;
        this.reader = reader;
    }

    private class QueueIterator
    implements Iterator<T> {
        T nextItem;

        QueueIterator() {
            this.nextItem = FileQueue.this.poll();
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public T next() {
            Object result = this.nextItem;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.nextItem = FileQueue.this.poll();
            return result;
        }
    }
}

