/*
 * Copyright 2018 Infobip Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.infobip.lib.popout.reader;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;

import lombok.Cleanup;
import lombok.SneakyThrows;
import lombok.val;

/**
 * This class implements a deserializer based on default {@link ObjectInputStream}.
 *
 * @see Deserializer
 * @since 1.0.0
 * @author Artem Labazin
 * @param <T> the result type of method {@code deserialize}
 */
public class DefaultDeserializer<T> implements Deserializer<T> {

    @Override
    @SneakyThrows
    @SuppressWarnings("unchecked")
    public T deserialize (byte[] bytes) {
        @Cleanup
        val byteArrayInputStream = new ByteArrayInputStream(bytes);
        @Cleanup
        val objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return (T) objectInputStream.readObject();
    }
}
