/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.writer;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import lombok.NonNull;
import org.infobip.lib.popout.MetadataFile;
import org.infobip.lib.popout.util.FilePattern;
import org.infobip.lib.popout.writer.FileWriter;
import org.infobip.lib.popout.writer.Serializer;

public class FolderWriter<T>
implements Closeable {
    @NonNull
    private final Path folder;
    @NonNull
    private final FilePattern filePattern;
    @NonNull
    private final Serializer<T> serializer;
    @NonNull
    private final Function<Path, FileWriter> createWriter;
    private final long maxFileSizeBytes;
    private final AtomicReference<Object> lazyCounter = new AtomicReference();
    private FileWriter currentFileWriter;

    public FolderWriter<T> init(@NonNull MetadataFile.Position position) {
        if (position == null) {
            throw new NullPointerException("position");
        }
        this.getLazyCounter().set(position.getIndex());
        int index = this.getLazyCounter().incrementAndGet();
        String name = this.filePattern.getFileNameWith(index);
        Path path = this.folder.resolve(name);
        this.currentFileWriter = this.createWriter.apply(path);
        this.currentFileWriter.position(position.getOffset());
        return this;
    }

    public void writeNext(@NonNull T element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        byte[] bytes = this.serializer.serialize(element);
        this.checkCurrentFileWriter();
        this.currentFileWriter.write(bytes);
    }

    public int getCurrentFileIndex() {
        return this.getLazyCounter().get();
    }

    public long getCurrentPosition() {
        return Optional.ofNullable(this.currentFileWriter).map(FileWriter::position).orElse(0L);
    }

    @Override
    public void close() throws IOException {
        if (this.currentFileWriter != null) {
            this.currentFileWriter.close();
        }
    }

    private void checkCurrentFileWriter() {
        if (this.currentFileWriter != null && this.currentFileWriter.currentFileSize() < this.maxFileSizeBytes) {
            return;
        }
        if (this.currentFileWriter != null) {
            this.currentFileWriter.close();
        }
        Path path = this.nextFile();
        this.currentFileWriter = this.createWriter.apply(path);
    }

    private Path nextFile() throws IOException {
        int index;
        String name;
        Path path;
        while (Files.exists(path = this.folder.resolve(name = this.filePattern.getFileNameWith(index = this.getLazyCounter().incrementAndGet())), new LinkOption[0])) {
        }
        return path;
    }

    private AtomicInteger initLazyCounter() {
        return Files.list(this.folder).map(Path::getFileName).map(Path::toString).filter(this.filePattern::matches).map(this.filePattern::extractIndex).min(Integer::compare).map(AtomicInteger::new).orElse(new AtomicInteger(0));
    }

    FolderWriter(@NonNull Path folder, @NonNull FilePattern filePattern, @NonNull Serializer<T> serializer, @NonNull Function<Path, FileWriter> createWriter, long maxFileSizeBytes, FileWriter currentFileWriter) {
        if (folder == null) {
            throw new NullPointerException("folder");
        }
        if (filePattern == null) {
            throw new NullPointerException("filePattern");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer");
        }
        if (createWriter == null) {
            throw new NullPointerException("createWriter");
        }
        this.folder = folder;
        this.filePattern = filePattern;
        this.serializer = serializer;
        this.createWriter = createWriter;
        this.maxFileSizeBytes = maxFileSizeBytes;
        this.currentFileWriter = currentFileWriter;
    }

    public static <T> FolderWriterBuilder<T> builder() {
        return new FolderWriterBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicInteger getLazyCounter() {
        Object value = this.lazyCounter.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.lazyCounter;
            synchronized (atomicReference) {
                value = this.lazyCounter.get();
                if (value == null) {
                    AtomicInteger actualValue = this.initLazyCounter();
                    value = actualValue == null ? this.lazyCounter : actualValue;
                    this.lazyCounter.set(value);
                }
            }
        }
        return (AtomicInteger)(value == this.lazyCounter ? null : value);
    }

    public static class FolderWriterBuilder<T> {
        private Path folder;
        private FilePattern filePattern;
        private Serializer<T> serializer;
        private Function<Path, FileWriter> createWriter;
        private long maxFileSizeBytes;
        private FileWriter currentFileWriter;

        FolderWriterBuilder() {
        }

        public FolderWriterBuilder<T> folder(Path folder) {
            this.folder = folder;
            return this;
        }

        public FolderWriterBuilder<T> filePattern(FilePattern filePattern) {
            this.filePattern = filePattern;
            return this;
        }

        public FolderWriterBuilder<T> serializer(Serializer<T> serializer) {
            this.serializer = serializer;
            return this;
        }

        public FolderWriterBuilder<T> createWriter(Function<Path, FileWriter> createWriter) {
            this.createWriter = createWriter;
            return this;
        }

        public FolderWriterBuilder<T> maxFileSizeBytes(long maxFileSizeBytes) {
            this.maxFileSizeBytes = maxFileSizeBytes;
            return this;
        }

        public FolderWriterBuilder<T> currentFileWriter(FileWriter currentFileWriter) {
            this.currentFileWriter = currentFileWriter;
            return this;
        }

        public FolderWriter<T> build() {
            return new FolderWriter<T>(this.folder, this.filePattern, this.serializer, this.createWriter, this.maxFileSizeBytes, this.currentFileWriter);
        }

        public String toString() {
            return "FolderWriter.FolderWriterBuilder(folder=" + this.folder + ", filePattern=" + this.filePattern + ", serializer=" + this.serializer + ", createWriter=" + this.createWriter + ", maxFileSizeBytes=" + this.maxFileSizeBytes + ", currentFileWriter=" + this.currentFileWriter + ")";
        }
    }
}

