/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import lombok.NonNull;
import org.infobip.lib.popout.writer.FileWriter;

public final class ChannelFileWriter
implements FileWriter {
    private final Path path;
    private final FileChannel channel;
    private final ByteBuffer recordLengthBuffer;

    public ChannelFileWriter(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.channel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        this.recordLengthBuffer = ByteBuffer.allocate(4);
    }

    @Override
    public long currentFileSize() {
        return this.channel.size();
    }

    @Override
    public long position() {
        return this.channel.position();
    }

    @Override
    public void position(long offset) {
        this.channel.position(offset);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public void write(byte[] bytes) {
        this.recordLengthBuffer.clear();
        this.recordLengthBuffer.putInt(bytes.length);
        this.recordLengthBuffer.flip();
        this.channel.write(this.recordLengthBuffer);
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length).put(bytes);
        buffer.flip();
        this.channel.write(buffer);
        this.channel.force(true);
    }

    @Override
    public void trim() {
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

