/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import lombok.NonNull;
import org.infobip.lib.popout.reader.FileReader;

public final class ChannelFileReader
implements FileReader {
    private final Path path;
    private final FileChannel channel;
    private final ByteBuffer recordLengthBuffer;

    public ChannelFileReader(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.channel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ);
        this.recordLengthBuffer = ByteBuffer.allocate(4);
    }

    @Override
    public boolean hasNext() {
        return this.channel.size() > this.channel.position();
    }

    @Override
    public Optional<byte[]> next() {
        return this.readInt().flatMap(this::read);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public long currentFileSize() {
        return this.channel.size();
    }

    @Override
    public long position() {
        return this.channel.position();
    }

    @Override
    public void position(long offset) {
        this.channel.position(offset);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    private Optional<Integer> readInt() {
        if (this.channel.read(this.recordLengthBuffer) == -1) {
            return Optional.empty();
        }
        this.recordLengthBuffer.flip();
        int length = this.recordLengthBuffer.getInt();
        this.recordLengthBuffer.clear();
        return Optional.of(length).filter(it -> it > 0);
    }

    private Optional<byte[]> read(int length) {
        ByteBuffer buffer = ByteBuffer.allocate(length);
        if (this.channel.read(buffer) == -1) {
            return Optional.empty();
        }
        return Optional.of(buffer.array());
    }
}

