/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout;

import java.io.Closeable;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import lombok.NonNull;
import org.infobip.lib.popout.util.ReflectionUtils;

public final class MetadataFile
implements Closeable {
    private static final short OFFSET_ELEMENTS = 0;
    private static final short OFFSET_HEAD = 8;
    private static final short OFFSET_TAIL = 20;
    private final MappedByteBuffer buffer;
    private final Position head;
    private final Position tail;
    private long elements;

    public MetadataFile(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        FileChannel channel = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, 32L);
        this.head = new Position(8);
        this.tail = new Position(20);
    }

    public void moveHead(int index, long offset) {
        if (this.elements == 0L) {
            throw new IllegalArgumentException("Queue is empty");
        }
        if (index > this.tail.getIndex()) {
            String message = "New head index " + index + " is greater than tail's index (" + this.tail.getIndex() + ')';
            throw new IllegalArgumentException(message);
        }
        if (index == this.tail.getIndex() && offset > this.tail.getOffset()) {
            String message = "New head offset " + offset + " is greater than tail's in the same index " + index;
            throw new IllegalArgumentException(message);
        }
        --this.elements;
        this.buffer.putLong(0, this.elements);
        this.head.move(index, offset);
        this.buffer.force();
    }

    public void moveTail(int index, long offset) {
        if (index < this.head.getIndex()) {
            String message = "New tail index " + index + " is lower than head's index (" + this.head.getIndex() + ')';
            throw new IllegalArgumentException(message);
        }
        if (index == this.head.getIndex() && offset < this.head.getOffset()) {
            String message = "New tail offset " + offset + " is lower than head's in the same index " + index;
            throw new IllegalArgumentException(message);
        }
        ++this.elements;
        this.buffer.putLong(0, this.elements);
        this.tail.move(index, offset);
        this.buffer.force();
    }

    @Override
    public void close() throws IOException {
        this.buffer.force();
        ReflectionUtils.getFieldValueFrom(this.buffer, "cleaner").map(it -> ReflectionUtils.invokeMethodOf(it, "clean", new Object[0]));
    }

    public Position getHead() {
        return this.head;
    }

    public Position getTail() {
        return this.tail;
    }

    public long getElements() {
        return this.elements;
    }

    public final class Position {
        final short writeOffset;
        int index;
        long offset;

        Position(short writeOffset) {
            this.writeOffset = writeOffset;
            this.index = MetadataFile.this.buffer.getInt(writeOffset);
            this.offset = MetadataFile.this.buffer.getLong(writeOffset + 4);
        }

        void move(int newIndex, long newOffset) {
            this.index = newIndex;
            this.offset = newOffset;
            MetadataFile.this.buffer.putInt(this.writeOffset, this.index);
            MetadataFile.this.buffer.putLong(this.writeOffset + 4, this.offset);
        }

        public int getIndex() {
            return this.index;
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

