/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.lib.popout;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.infobip.lib.popout.FileQueue;
import org.infobip.lib.popout.MetadataFile;
import org.infobip.lib.popout.reader.ChannelFileReader;
import org.infobip.lib.popout.reader.DefaultDeserializer;
import org.infobip.lib.popout.reader.Deserializer;
import org.infobip.lib.popout.reader.FileReader;
import org.infobip.lib.popout.reader.FolderReader;
import org.infobip.lib.popout.reader.MmapFileReader;
import org.infobip.lib.popout.util.FilePattern;
import org.infobip.lib.popout.writer.ChannelFileWriter;
import org.infobip.lib.popout.writer.DefaultSerializer;
import org.infobip.lib.popout.writer.FileWriter;
import org.infobip.lib.popout.writer.FolderWriter;
import org.infobip.lib.popout.writer.MmapFileWriter;
import org.infobip.lib.popout.writer.Serializer;

public final class FileQueueBuilder<T> {
    private final Path folder;
    private Path metadataFile;
    private FilePattern filePattern = new FilePattern("batch-", ".queue");
    private long maxFileSizeBytes = 0x6400000L;
    private boolean mmapEnabled;
    private int mmapBufferSizeBytes = 8192;
    private Serializer<T> serializer = new DefaultSerializer();
    private Deserializer<T> deserializer = new DefaultDeserializer();

    public FileQueueBuilder<T> metadataFile(@NonNull String metadataFilePath) {
        if (metadataFilePath == null) {
            throw new NullPointerException("metadataFilePath");
        }
        Path path = Paths.get(metadataFilePath, new String[0]);
        return this.metadataFile(path);
    }

    public FileQueueBuilder<T> metadataFile(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.metadataFile = path;
        return this;
    }

    public FileQueueBuilder<T> filePattern(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        return this.filePattern(FilePattern.from(pattern));
    }

    public FileQueueBuilder<T> filePattern(@NonNull FilePattern pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern");
        }
        this.filePattern = pattern;
        return this;
    }

    public FileQueueBuilder<T> maxFileSizeBytes(long size) {
        this.maxFileSizeBytes = size;
        return this;
    }

    public FileQueueBuilder<T> fileMmapEnable() {
        this.mmapEnabled = true;
        return this;
    }

    public FileQueueBuilder<T> fileMmapEnable(int bufferSizeBytes) {
        this.mmapBufferSizeBytes = bufferSizeBytes;
        return this.fileMmapEnable();
    }

    public FileQueueBuilder<T> serializer(@NonNull Serializer<T> elementsSerializer) {
        if (elementsSerializer == null) {
            throw new NullPointerException("elementsSerializer");
        }
        this.serializer = elementsSerializer;
        return this;
    }

    public FileQueueBuilder<T> deserializer(@NonNull Deserializer<T> elementsDeserializer) {
        if (elementsDeserializer == null) {
            throw new NullPointerException("elementsDeserializer");
        }
        this.deserializer = elementsDeserializer;
        return this;
    }

    public FileQueue<T> build() {
        Function<Path, FileWriter> createWriter;
        Function<Path, FileReader> createReader;
        Path metadataFilePath = Optional.ofNullable(this.metadataFile).map(this.folder::resolve).orElseGet(() -> this.folder.resolve("queue.metadata"));
        MetadataFile metadata = new MetadataFile(metadataFilePath);
        if (this.mmapEnabled) {
            createReader = path -> new MmapFileReader((Path)path, this.mmapBufferSizeBytes);
            createWriter = path -> new MmapFileWriter((Path)path, this.mmapBufferSizeBytes);
        } else {
            createReader = path -> new ChannelFileReader((Path)path);
            createWriter = path -> new ChannelFileWriter((Path)path);
        }
        FolderReader folderReader = FolderReader.builder().folder(this.folder).filePattern(this.filePattern).deserializer(this.deserializer).createReader(createReader).build().init(metadata.getHead());
        FolderWriter folderWriter = FolderWriter.builder().folder(this.folder).filePattern(this.filePattern).serializer(this.serializer).createWriter(createWriter).maxFileSizeBytes(this.maxFileSizeBytes).build().init(metadata.getTail());
        return new FileQueue(metadata, folderWriter, folderReader);
    }

    FileQueueBuilder(Path folder) {
        this.folder = folder;
    }
}

