/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.server.commons.controller.ResourceServiceBuilder;
import org.infinispan.server.commons.service.Builder;
import org.jboss.as.clustering.infinispan.subsystem.ComponentConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class ScheduledThreadPoolBuilder
extends ComponentConfigurationBuilder<ThreadPoolConfiguration>
implements ResourceServiceBuilder<ThreadPoolConfiguration> {
    private final ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(null);
    private final ScheduledThreadPoolDefinition definition;

    ScheduledThreadPoolBuilder(ScheduledThreadPoolDefinition definition, String containerName) {
        super(definition.getServiceName(containerName));
        this.definition = definition;
    }

    public Builder<ThreadPoolConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final int maxThreads = this.definition.getMaxThreads().resolveModelAttribute(context, model).asInt();
        final long keepAliveTime = this.definition.getKeepAliveTime().resolveModelAttribute(context, model).asLong();
        ThreadPoolExecutorFactory<ScheduledExecutorService> factory = new ThreadPoolExecutorFactory<ScheduledExecutorService>(){

            public ScheduledExecutorService createExecutor(ThreadFactory factory) {
                ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(0);
                scheduledExecutor.setCorePoolSize(maxThreads);
                scheduledExecutor.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
                return scheduledExecutor;
            }

            public void validate() {
            }
        };
        this.builder.threadPoolFactory((ThreadPoolExecutorFactory)factory);
        return this;
    }

    public ThreadPoolConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.builder.create();
    }
}

