/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.time.format.DateTimeFormatter;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.jboss.as.clustering.infinispan.subsystem.AddAliasCommand;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerCommands;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerConfigurationsResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerCountersResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerModulesResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerRemoveHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerSecurityResource;
import org.jboss.as.clustering.infinispan.subsystem.CliInterpreterHandler;
import org.jboss.as.clustering.infinispan.subsystem.ClusterRebalanceAttributeHandler;
import org.jboss.as.clustering.infinispan.subsystem.DateTimeValidator;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResource;
import org.jboss.as.clustering.infinispan.subsystem.GetProtoSchemaErrorsHandler;
import org.jboss.as.clustering.infinispan.subsystem.GetProtobufSchemaHandler;
import org.jboss.as.clustering.infinispan.subsystem.GetProtobufSchemaNamesHandler;
import org.jboss.as.clustering.infinispan.subsystem.GetProtobufSchemasWithErrorsHandler;
import org.jboss.as.clustering.infinispan.subsystem.GlobalStateResource;
import org.jboss.as.clustering.infinispan.subsystem.HealthResource;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheResource;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheResource;
import org.jboss.as.clustering.infinispan.subsystem.ModuleIdentifierValidator;
import org.jboss.as.clustering.infinispan.subsystem.RegisterProtoSchemasOperationHandler;
import org.jboss.as.clustering.infinispan.subsystem.RemoveAliasCommand;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheResource;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResource;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResource;
import org.jboss.as.clustering.infinispan.subsystem.TransportResource;
import org.jboss.as.clustering.infinispan.subsystem.UnregisterProtoSchemasOperationHandler;
import org.jboss.as.clustering.infinispan.subsystem.UploadProtoFileOperationHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CacheContainerResource
extends SimpleResourceDefinition {
    public static final PathElement CONTAINER_PATH = PathElement.pathElement((String)"cache-container");
    static final AttributeDefinition ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alias", ModelType.STRING, true).setXmlName(Attribute.NAME.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleListAttributeDefinition ALIASES = ((SimpleListAttributeDefinition.Builder)SimpleListAttributeDefinition.Builder.of((String)"aliases", (AttributeDefinition)ALIAS).setRequired(false)).build();
    static final SimpleAttributeDefinition CACHE_CONTAINER_MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setXmlName(Attribute.MODULE.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator((ParameterValidator)new ModuleIdentifierValidator(true))).setDefaultValue(new ModelNode().set("org.infinispan.extension"))).build();
    static final SimpleAttributeDefinition DEFAULT_CACHE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("default-cache", ModelType.STRING, true).setXmlName(Attribute.DEFAULT_CACHE.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition JNDI_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("jndi-name", ModelType.STRING, true).setXmlName(Attribute.JNDI_NAME.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, true).setXmlName(Attribute.NAME.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition STATISTICS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("statistics", ModelType.BOOLEAN, true).setXmlName(Attribute.STATISTICS.getLocalName())).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode().set(true))).build();
    static final SimpleAttributeDefinition CLUSTER_REBALANCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cluster-rebalance", ModelType.BOOLEAN, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).setDefaultValue(new ModelNode().set(true))).setStorageRuntime()).build();
    static final AttributeDefinition[] CACHE_CONTAINER_ATTRIBUTES = new AttributeDefinition[]{DEFAULT_CACHE, ALIASES, JNDI_NAME, CACHE_CONTAINER_MODULE, STATISTICS};
    static final OperationDefinition ALIAS_ADD = new SimpleOperationDefinitionBuilder("add-alias", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container.alias")).setParameters(new AttributeDefinition[]{NAME}).build();
    static final OperationDefinition ALIAS_REMOVE = new SimpleOperationDefinitionBuilder("remove-alias", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container.alias")).setParameters(new AttributeDefinition[]{NAME}).build();
    static final ListAttributeDefinition PROTO_URLS = new StringListAttributeDefinition.Builder("file-urls").build();
    static final SimpleAttributeDefinition PROTO_NAME = new SimpleAttributeDefinitionBuilder("file-name", ModelType.STRING, false).build();
    static final ListAttributeDefinition PROTO_NAMES = new StringListAttributeDefinition.Builder("file-names").build();
    static final ListAttributeDefinition PROTO_CONTENTS = new StringListAttributeDefinition.Builder("file-contents").build();
    static final OperationDefinition GET_PROTO_NAMES = new SimpleOperationDefinitionBuilder("get-proto-schema-names", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setRuntimeOnly().build();
    static final OperationDefinition GET_PROTO = new SimpleOperationDefinitionBuilder("get-proto-schema", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{PROTO_NAME}).setRuntimeOnly().build();
    static final OperationDefinition GET_PROTO_SCHEMAS_WITH_ERRORS = new SimpleOperationDefinitionBuilder("get-proto-schemas-with-errors", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setRuntimeOnly().build();
    static final OperationDefinition GET_PROTO_SCHEMA_ERRORS = new SimpleOperationDefinitionBuilder("get-proto-schema-errors", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{PROTO_NAME}).setRuntimeOnly().build();
    static final OperationDefinition UPLOAD_PROTO = new SimpleOperationDefinitionBuilder("upload-proto-schemas", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{PROTO_NAMES, PROTO_URLS}).setRuntimeOnly().build();
    static final OperationDefinition REGISTER_PROTO = new SimpleOperationDefinitionBuilder("register-proto-schemas", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{PROTO_NAMES, PROTO_CONTENTS}).setRuntimeOnly().build();
    static final OperationDefinition UNREGISTER_PROTO = new SimpleOperationDefinitionBuilder("unregister-proto-schemas", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{PROTO_NAMES}).setRuntimeOnly().build();
    static final OperationDefinition CLI_INTERPRETER = new SimpleOperationDefinitionBuilder("cli-interpreter", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setRuntimeOnly().build();
    static final SimpleAttributeDefinition SITE_NAME = new SimpleAttributeDefinitionBuilder("site-name", ModelType.STRING, false).build();
    static final OperationDefinition BACKUP_TAKE_SITE_OFFLINE = new SimpleOperationDefinitionBuilder("take-site-offline", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{SITE_NAME}).setRuntimeOnly().build();
    static final OperationDefinition BACKUP_BRING_SITE_ONLINE = new SimpleOperationDefinitionBuilder("bring-site-online", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{SITE_NAME}).setRuntimeOnly().build();
    static final OperationDefinition BACKUP_PUSH_STATE = new SimpleOperationDefinitionBuilder("push-state", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{SITE_NAME}).setRuntimeOnly().build();
    static final OperationDefinition BACKUP_CANCEL_PUSH_STATE = new SimpleOperationDefinitionBuilder("cancel-push-state", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{SITE_NAME}).setRuntimeOnly().build();
    static final SimpleAttributeDefinition COUNT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"lines", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).build();
    static final SimpleAttributeDefinition SINCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"since", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setValidator((ParameterValidator)new DateTimeValidator(DateTimeFormatter.ISO_DATE_TIME, true, true))).build();
    static final SimpleAttributeDefinition CATEGORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"category", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(EventLogCategory.class, true, true))).build();
    static final SimpleAttributeDefinition LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"level", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(EventLogLevel.class, true, true))).build();
    static final OperationDefinition READ_EVENT_LOG = new SimpleOperationDefinitionBuilder("read-event-log", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{COUNT, SINCE, CATEGORY, LEVEL}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).setReadOnly().setRuntimeOnly().build();
    static final OperationDefinition TASK_LIST = new SimpleOperationDefinitionBuilder("task-list", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).setReadOnly().setRuntimeOnly().build();
    static final SimpleAttributeDefinition TASK_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition TASK_CACHE_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cache-name", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).build();
    static final SimpleMapAttributeDefinition TASK_PARAMETERS = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("parameters", ModelType.STRING, true).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition TASK_ASYNC = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"async", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    static final OperationDefinition TASK_EXECUTE = new SimpleOperationDefinitionBuilder("task-execute", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{TASK_NAME, TASK_CACHE_NAME, TASK_PARAMETERS, TASK_ASYNC}).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).setReadOnly().setRuntimeOnly().build();
    static final OperationDefinition TASK_STATUS = new SimpleOperationDefinitionBuilder("task-status", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).setReadOnly().setRuntimeOnly().build();
    static final SimpleAttributeDefinition SCRIPT_NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition SCRIPT_CODE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"code", (ModelType)ModelType.STRING, (boolean)false).setAllowExpression(true)).build();
    static final OperationDefinition SCRIPT_ADD = new SimpleOperationDefinitionBuilder("script-add", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{SCRIPT_NAME, SCRIPT_CODE}).setRuntimeOnly().build();
    static final OperationDefinition SCRIPT_CAT = new SimpleOperationDefinitionBuilder("script-cat", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{SCRIPT_NAME}).setReplyType(ModelType.STRING).setReadOnly().setRuntimeOnly().build();
    static final OperationDefinition SCRIPT_REMOVE = new SimpleOperationDefinitionBuilder("script-remove", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{SCRIPT_NAME}).setRuntimeOnly().build();
    static final SimpleAttributeDefinition BOOL_VALUE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"value", (ModelType)ModelType.BOOLEAN, (boolean)false).setDefaultValue(new ModelNode(true))).build();
    static final OperationDefinition CLUSTER_REBALANCE_OPERATION = new SimpleOperationDefinitionBuilder("cluster-rebalance", (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container")).setParameters(new AttributeDefinition[]{BOOL_VALUE}).setRuntimeOnly().build();
    private final ResolvePathHandler resolvePathHandler;
    private final PathManager pathManager;
    private final boolean runtimeRegistration;

    public CacheContainerResource(ResolvePathHandler resolvePathHandler, PathManager pathManager, boolean runtimeRegistration) {
        super(CONTAINER_PATH, (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("cache-container"), (OperationStepHandler)new CacheContainerAddHandler(), (OperationStepHandler)new CacheContainerRemoveHandler());
        this.resolvePathHandler = resolvePathHandler;
        this.pathManager = pathManager;
        this.runtimeRegistration = runtimeRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(CACHE_CONTAINER_ATTRIBUTES);
        for (AttributeDefinition attr : CACHE_CONTAINER_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
        if (this.runtimeRegistration) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CLUSTER_REBALANCE, (OperationStepHandler)ClusterRebalanceAttributeHandler.INSTANCE, (OperationStepHandler)ClusterRebalanceAttributeHandler.INSTANCE);
            CacheContainerMetricsHandler.INSTANCE.registerMetrics(resourceRegistration);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(ALIAS_ADD, (OperationStepHandler)AddAliasCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(ALIAS_REMOVE, (OperationStepHandler)RemoveAliasCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(GET_PROTO_NAMES, (OperationStepHandler)GetProtobufSchemaNamesHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(GET_PROTO, (OperationStepHandler)GetProtobufSchemaHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(GET_PROTO_SCHEMAS_WITH_ERRORS, (OperationStepHandler)GetProtobufSchemasWithErrorsHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(GET_PROTO_SCHEMA_ERRORS, (OperationStepHandler)GetProtoSchemaErrorsHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(UPLOAD_PROTO, (OperationStepHandler)UploadProtoFileOperationHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(REGISTER_PROTO, (OperationStepHandler)RegisterProtoSchemasOperationHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(UNREGISTER_PROTO, (OperationStepHandler)UnregisterProtoSchemasOperationHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(CLI_INTERPRETER, (OperationStepHandler)CliInterpreterHandler.INSTANCE);
        resourceRegistration.registerOperationHandler(BACKUP_TAKE_SITE_OFFLINE, (OperationStepHandler)CacheContainerCommands.BackupTakeSiteOfflineCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(BACKUP_BRING_SITE_ONLINE, (OperationStepHandler)CacheContainerCommands.BackupBringSiteOnlineCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(BACKUP_PUSH_STATE, (OperationStepHandler)CacheContainerCommands.BackupPushStateCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(BACKUP_CANCEL_PUSH_STATE, (OperationStepHandler)CacheContainerCommands.BackupCancelPushStateCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(READ_EVENT_LOG, (OperationStepHandler)CacheContainerCommands.ReadEventLogCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(SCRIPT_ADD, (OperationStepHandler)CacheContainerCommands.ScriptAddCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(SCRIPT_CAT, (OperationStepHandler)CacheContainerCommands.ScriptCatCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(SCRIPT_REMOVE, (OperationStepHandler)CacheContainerCommands.ScriptRemoveCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(TASK_LIST, (OperationStepHandler)CacheContainerCommands.TaskListCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(TASK_EXECUTE, (OperationStepHandler)CacheContainerCommands.TaskExecuteCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(TASK_STATUS, (OperationStepHandler)CacheContainerCommands.TaskStatusCommand.INSTANCE);
        resourceRegistration.registerOperationHandler(CLUSTER_REBALANCE_OPERATION, (OperationStepHandler)CacheContainerCommands.ClusterRebalanceCommand.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new HealthResource(this.pathManager, this.runtimeRegistration));
        resourceRegistration.registerSubModel((ResourceDefinition)new TransportResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new CacheContainerSecurityResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new CacheContainerModulesResource());
        resourceRegistration.registerSubModel((ResourceDefinition)new GlobalStateResource());
        for (ThreadPoolResource threadPoolResource : ThreadPoolResource.values()) {
            resourceRegistration.registerSubModel((ResourceDefinition)threadPoolResource);
        }
        for (Enum enum_ : ScheduledThreadPoolResource.values()) {
            resourceRegistration.registerSubModel((ResourceDefinition)enum_);
        }
        resourceRegistration.registerSubModel((ResourceDefinition)new CacheContainerConfigurationsResource(this.resolvePathHandler, this.runtimeRegistration));
        resourceRegistration.registerSubModel((ResourceDefinition)new LocalCacheResource(this.resolvePathHandler, this.runtimeRegistration));
        resourceRegistration.registerSubModel((ResourceDefinition)new InvalidationCacheResource(this.resolvePathHandler, this.runtimeRegistration));
        resourceRegistration.registerSubModel((ResourceDefinition)new ReplicatedCacheResource(this.resolvePathHandler, this.runtimeRegistration));
        resourceRegistration.registerSubModel((ResourceDefinition)new DistributedCacheResource(this.resolvePathHandler, this.runtimeRegistration));
        resourceRegistration.registerSubModel((ResourceDefinition)new CacheContainerCountersResource(this.resolvePathHandler, this.runtimeRegistration));
    }
}

