/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.naming.deployment.JndiName;

class InfinispanJndiName {
    private static final String DEFAULT_JNDI_NAMESPACE = "java:jboss";

    InfinispanJndiName() {
    }

    private static JndiName defaultCacheContainerJndiName(String containerName) {
        return JndiName.of((String)DEFAULT_JNDI_NAMESPACE).append("datagrid-infinispan").append("container").append(containerName);
    }

    private static JndiName defaultCacheJndiName(String containerName, String cacheName) {
        return InfinispanJndiName.defaultCacheContainerJndiName(containerName).append("cache").append(cacheName);
    }

    private static JndiName toJndiName(String value) {
        return value.startsWith("java:") ? JndiName.of((String)value) : JndiName.of((String)DEFAULT_JNDI_NAMESPACE).append(value.startsWith("/") ? value.substring(1) : value);
    }

    static String createCacheJndiName(String jndiNameString, String containerName, String cacheName) {
        JndiName jndiName = jndiNameString != null ? InfinispanJndiName.toJndiName(jndiNameString) : InfinispanJndiName.defaultCacheJndiName(containerName, cacheName);
        return jndiName.getAbsoluteName();
    }

    static String createCacheContainerJndiName(String containerName) {
        return InfinispanJndiName.defaultCacheContainerJndiName(containerName).getAbsoluteName();
    }
}

