/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.infinispan.topology.ClusterTopologyManager;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.SecurityActions;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class ClusterRebalanceAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final ClusterRebalanceAttributeHandler INSTANCE = new ClusterRebalanceAttributeHandler();

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
        if (controller != null) {
            ClusterTopologyManager topologyManager;
            EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)controller.getValue();
            if (cacheContainerName != null && (topologyManager = (ClusterTopologyManager)SecurityActions.getGlobalComponentRegistry(cacheManager).getComponent(ClusterTopologyManager.class)) != null) {
                try {
                    if (operation.hasDefined("value")) {
                        ModelNode newValue = operation.get("value");
                        topologyManager.setRebalancingEnabled(newValue.asBoolean());
                    } else {
                        context.getResult().set(new ModelNode().set(topologyManager.isRebalancingEnabled()));
                    }
                }
                catch (Exception e) {
                    throw new OperationFailedException(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage()));
                }
            }
        }
        context.stepCompleted();
    }
}

