/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.clustering.infinispan.subsystem.OperationTestCaseBase;
import org.jboss.as.clustering.infinispan.subsystem.PersistenceConfigurationResource;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SoftIndexFeatureDisabledTestCase
extends OperationTestCaseBase {
    private static final String FEATURE_NAME = "org.infinispan.feature.soft-index-file-store";
    private static final String CONTAINER_NAME = "local";
    private static final String SIMPLE_CACHE_XML = "simple-cache.xml";

    @Override
    protected String getSubsystemXml() throws IOException {
        return this.readResource(SIMPLE_CACHE_XML);
    }

    @After
    public void after() {
        System.clearProperty(FEATURE_NAME);
    }

    @Test
    public void testSoftIndexFeatureNotRegistered() throws Exception {
        KernelServices service = this.createKernelServicesBuilder().setSubsystemXml(this.getSubsystemXml()).build();
        System.setProperty(FEATURE_NAME, "true");
        PathAddress persistenceAddr = this.createConfigurationWithEmptyPersistence(service);
        PathAddress sifsAddr = persistenceAddr.append("soft-index-file-store", "sifs");
        this.executeAndAssertOutcome(service, Util.createAddOperation((PathAddress)sifsAddr), "success");
        this.readStoreAndAssertOutcome(service, sifsAddr, "success");
        System.setProperty(FEATURE_NAME, "false");
        service = this.createKernelServicesBuilder().setSubsystemXml(this.getSubsystemXml()).build();
        this.createConfigurationWithEmptyPersistence(service);
        this.executeAndAssertOutcome(service, Util.createAddOperation((PathAddress)sifsAddr), "failed");
    }

    private void readStoreAndAssertOutcome(KernelServices service, PathAddress address, String outcome) {
        ModelNode readOp = new ModelNode();
        readOp.get("operation").set("read-resource");
        readOp.get("address").set(address.toModelNode());
        ModelNode result = service.executeOperation(readOp, new InputStream[0]);
        Assert.assertEquals((String)result.asString(), (Object)outcome, (Object)result.get("outcome").asString());
    }

    private PathAddress createConfigurationWithEmptyPersistence(KernelServices service) {
        PathAddress cacheConfAddres = SoftIndexFeatureDisabledTestCase.getCacheConfigurationAddress(CONTAINER_NAME, "local-cache-configuration", "example");
        PathAddress persistenceAddr = cacheConfAddres.append(new PathElement[]{PersistenceConfigurationResource.PATH});
        this.executeAndAssertOutcome(service, Util.createAddOperation((PathAddress)cacheConfAddres), "success");
        this.executeAndAssertOutcome(service, Util.createAddOperation((PathAddress)persistenceAddr), "success");
        return persistenceAddr;
    }
}

