/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.Serializable;
import org.infinispan.server.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.ExtensionRegistryType;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.txn.subsystem.TransactionExtension;

public class InfinispanSubsystemDependenciesInitialization
extends AdditionalInitialization
implements Serializable {
    private static final long serialVersionUID = -4433079373360352449L;
    private final RunningMode mode;

    public InfinispanSubsystemDependenciesInitialization() {
        this(RunningMode.ADMIN_ONLY);
    }

    public InfinispanSubsystemDependenciesInitialization(RunningMode mode) {
        this.mode = mode;
    }

    protected RunningMode getRunningMode() {
        return this.mode;
    }

    protected void initializeExtraSubystemsAndModel(ExtensionRegistry registry, Resource root, ManagementResourceRegistration registration) {
        this.initializeJGroupsSubsystem(registry, root, registration);
        this.initializeTxnSubsystem(registry, root, registration);
    }

    private void initializeJGroupsSubsystem(ExtensionRegistry registry, Resource root, ManagementResourceRegistration registration) {
        new JGroupsExtension().initialize(registry.getExtensionContext("jgroups", registration, ExtensionRegistryType.MASTER));
        Resource subsystem = Resource.Factory.create();
        subsystem.getModel().get("default-stack").set("tcp");
        root.registerChild(PathElement.pathElement((String)"subsystem", (String)"datagrid-jgroups"), subsystem);
        Resource stack = Resource.Factory.create();
        subsystem.registerChild(PathElement.pathElement((String)"stack", (String)"tcp"), stack);
        Resource transport = Resource.Factory.create();
        transport.getModel().get("type").set("TCP");
        stack.registerChild(PathElement.pathElement((String)"transport", (String)"TRANSPORT"), transport);
    }

    private void initializeTxnSubsystem(ExtensionRegistry registry, Resource root, ManagementResourceRegistration registration) {
        new TransactionExtension().initialize(registry.getExtensionContext("transactions", registration, ExtensionRegistryType.MASTER));
    }
}

