/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.OperationTestCaseBase;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class IndexedOperationsTestCase
extends OperationTestCaseBase {
    @Override
    protected String getSubsystemXml() throws IOException {
        return this.readResource("indexing-inheritance.xml");
    }

    @Test
    public void testIndexedCacheInheritance() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices servicesA = this.createKernelServicesBuilder().setSubsystemXml(subsystemXml).build();
        PathAddress address = IndexedOperationsTestCase.getCacheConfigurationAddress("indexing", "replicated-cache-configuration", "booksCache").append("indexing", "INDEXING");
        ModelNode readOp = new ModelNode();
        readOp.get("operation").set("read-attribute");
        readOp.get("address").set(address.toModelNode());
        readOp.get("name").set("indexing");
        ModelNode result = servicesA.executeOperation(readOp, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)Indexing.PRIMARY_OWNER.toString(), (Object)result.get("result").asString());
    }

    @Test
    public void testIndexingPropertiesNoRestart() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices servicesA = this.createKernelServicesBuilder().setSubsystemXml(subsystemXml).build();
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ModelNode configAddOp = steps.add();
        configAddOp.get("operation").set("add");
        configAddOp.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanExtension.SUBSYSTEM_PATH}).append("cache-container", "indexing").append("configurations", "CONFIGURATIONS").append("local-cache-configuration", "manualIndexingCacheConfig").toModelNode());
        configAddOp.get("template").set(true);
        PathAddress indexingAddress = PathAddress.pathAddress((ModelNode)configAddOp.get("address")).append("indexing", "INDEXING");
        ModelNode indexingAdd = Util.createAddOperation((PathAddress)indexingAddress);
        indexingAdd.get("indexing").set("PRIMARY_OWNER");
        indexingAdd.get("indexing-properties").get("default.directory_provider").set("local-heap");
        indexingAdd.get("indexing-properties").get("hibernate.search.jmx_enabled").set("true");
        indexingAdd.get("indexing-properties").get("lucene_version").set("LUCENE_CURRENT");
        indexingAdd.get("indexing-properties").get("hibernate.search.indexing_strategy").set("manual");
        steps.add(indexingAdd);
        ModelNode cacheAddOp = steps.add();
        cacheAddOp.get("operation").set("add");
        cacheAddOp.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanExtension.SUBSYSTEM_PATH}).append("cache-container", "indexing").append("local-cache", "manualIndexingCache").toModelNode());
        cacheAddOp.get("configuration").set("manualIndexingCacheConfig");
        ModelNode result = servicesA.executeOperation(composite, new InputStream[0]);
        Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
        this.assertServerState(servicesA, "running");
    }
}

