/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.as.clustering.infinispan.io.AbstractSimpleExternalizer;

public class ExternalizableExternalizer<T extends Externalizable>
extends AbstractSimpleExternalizer<T> {
    private static final long serialVersionUID = -5938201796254055389L;

    public ExternalizableExternalizer(Class<T> targetClass) {
        super(targetClass);
    }

    public void writeObject(ObjectOutput output, T object) throws IOException {
        object.writeExternal(output);
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        PrivilegedExceptionAction<Externalizable> action = () -> (Externalizable)this.getTargetClass().newInstance();
        try {
            Externalizable object = AccessController.doPrivileged(action);
            object.readExternal(input);
            return (T)object;
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e.getCause());
        }
    }
}

