/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.InputStream;
import org.jboss.as.clustering.infinispan.subsystem.OperationSequencesTestCase;
import org.jboss.as.clustering.infinispan.subsystem.PersistenceConfigurationResource;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class PersistenceResourceTestCase
extends OperationSequencesTestCase {
    @Test
    public void testStoreAddRemoveViaAlias() throws Exception {
        String subsystemXml = this.getSubsystemXml();
        KernelServices service = this.createKernelServicesBuilder().setSubsystemXml(subsystemXml).build();
        String container = "maximal2";
        PathAddress containerAddr = PersistenceResourceTestCase.getCacheContainerAddress(container);
        PathAddress confParentAddr = containerAddr.append("configurations", "CONFIGURATIONS");
        PathAddress cacheConfAddres = PersistenceResourceTestCase.getCacheConfigurationAddress(container, "local-cache-configuration", "example");
        PathAddress persistenceAddr = cacheConfAddres.append(new PathElement[]{PersistenceConfigurationResource.PATH});
        PathAddress fs1ActualAddr = persistenceAddr.append("file-store", "fs1");
        PathAddress fs2ActualAddr = persistenceAddr.append("file-store", "fs2");
        PathAddress fs1Alias = cacheConfAddres.append("file-store", "fs1");
        PathAddress fs2Alias = cacheConfAddres.append("file-store", "fs2");
        this.executeAndAssertOutcome(service, Util.createAddOperation((PathAddress)containerAddr), "success");
        this.executeAndAssertOutcome(service, Util.createAddOperation((PathAddress)confParentAddr), "success");
        this.executeAndAssertOutcome(service, Util.createAddOperation((PathAddress)cacheConfAddres), "success");
        this.executeAndAssertOutcome(service, Util.createAddOperation((PathAddress)persistenceAddr), "success");
        this.executeAndAssertOutcome(service, Util.createAddOperation((PathAddress)fs1ActualAddr), "success");
        this.executeAndAssertOutcome(service, Util.createAddOperation((PathAddress)fs2Alias), "success");
        this.readFileStoreAndAssertOutcome(service, fs1ActualAddr, "success");
        this.readFileStoreAndAssertOutcome(service, fs1Alias, "success");
        this.readFileStoreAndAssertOutcome(service, fs2ActualAddr, "success");
        this.readFileStoreAndAssertOutcome(service, fs2Alias, "success");
        this.executeAndAssertOutcome(service, Util.createRemoveOperation((PathAddress)fs1Alias), "success");
        this.executeAndAssertOutcome(service, Util.createRemoveOperation((PathAddress)fs2ActualAddr), "success");
        this.readFileStoreAndAssertOutcome(service, fs1ActualAddr, "failed");
        this.readFileStoreAndAssertOutcome(service, fs1Alias, "failed");
        this.readFileStoreAndAssertOutcome(service, fs2ActualAddr, "failed");
        this.readFileStoreAndAssertOutcome(service, fs2Alias, "failed");
    }

    private void readFileStoreAndAssertOutcome(KernelServices service, PathAddress address, String outcome) {
        ModelNode readOp = new ModelNode();
        readOp.get("operation").set("read-resource");
        readOp.get("address").set(address.toModelNode());
        ModelNode result = service.executeOperation(readOp, new InputStream[0]);
        Assert.assertEquals((String)result.asString(), (Object)outcome, (Object)result.get("outcome").asString());
    }
}

