/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.cs.factory;

import java.util.function.Supplier;
import org.jboss.as.clustering.infinispan.cs.factory.CustomStoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.cs.factory.CustomStoreWithConfiguration;
import org.jboss.as.clustering.infinispan.cs.factory.CustomStoreWithConfigurationAndBuilder;
import org.jboss.as.clustering.infinispan.cs.factory.CustomStoreWithoutConfiguration;
import org.jboss.as.clustering.infinispan.cs.factory.DeployedCacheStoreMetadata;
import org.junit.Assert;
import org.junit.Test;

public class DeployedCacheStoreMetadataTest {
    @Test
    public void testImportingMetadataWithLoaderWriterClassOnly() {
        Supplier<Object> instanceSupplier = CustomStoreWithoutConfiguration::new;
        Object loaderWriterRawInstance = instanceSupplier.get();
        DeployedCacheStoreMetadata deployedCacheStoreMetadata = DeployedCacheStoreMetadata.fromDeployedStoreInstance(instanceSupplier);
        Assert.assertEquals(org.infinispan.configuration.cache.CustomStoreConfigurationBuilder.class, (Object)deployedCacheStoreMetadata.getStoreBuilderClass());
        Assert.assertEquals((Object)loaderWriterRawInstance.getClass().getName(), (Object)deployedCacheStoreMetadata.getDeployedCacheClassName());
    }

    @Test
    public void testImportingMetadataWithLoaderWriterWithConfiguration() {
        Supplier<Object> instanceSupplier = CustomStoreWithConfiguration::new;
        DeployedCacheStoreMetadata deployedCacheStoreMetadata = DeployedCacheStoreMetadata.fromDeployedStoreInstance(instanceSupplier);
        Assert.assertEquals(org.infinispan.configuration.cache.CustomStoreConfigurationBuilder.class, (Object)deployedCacheStoreMetadata.getStoreBuilderClass());
    }

    @Test
    public void testImportingMetadataWithLoaderWriterWithConfigurationAndBuilder() {
        DeployedCacheStoreMetadata deployedCacheStoreMetadata = DeployedCacheStoreMetadata.fromDeployedStoreInstance(CustomStoreWithConfigurationAndBuilder::new);
        Assert.assertEquals(CustomStoreConfigurationBuilder.class, (Object)deployedCacheStoreMetadata.getStoreBuilderClass());
    }
}

