package org.infinispan.server.jgroups.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URL;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-05-03T12:56:27-0400")
public class JGroupsLogger_$logger extends DelegatingBasicLogger implements JGroupsLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JGroupsLogger_$logger.class.getName();
    public JGroupsLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str());
    }
    private static final String activatingSubsystem = "DGJGRP0001: Activating JGroups subsystem.";
    protected String activatingSubsystem$str() {
        return activatingSubsystem;
    }
    @Override
    public final void setProtocolPropertyValue(final String protocol, final String property, final Object value) {
        super.log.logf(FQCN, TRACE, null, setProtocolPropertyValue$str(), protocol, property, value);
    }
    private static final String setProtocolPropertyValue = "DGJGRP0002: Setting %s.%s=%d";
    protected String setProtocolPropertyValue$str() {
        return setProtocolPropertyValue;
    }
    @Override
    public final void nonExistentProtocolPropertyValue(final Throwable cause, final String protocolName, final String propertyName, final Object propertyValue) {
        super.log.logf(FQCN, TRACE, cause, nonExistentProtocolPropertyValue$str(), protocolName, propertyName, propertyValue);
    }
    private static final String nonExistentProtocolPropertyValue = "DGJGRP0003: Failed to set non-existent %s.%s=%d";
    protected String nonExistentProtocolPropertyValue$str() {
        return nonExistentProtocolPropertyValue;
    }
    @Override
    public final void couldNotSetAddressAndPortNoMulticastSocket(final Throwable cause, final String protocolName, final String addressProperty, final String protocolNameAgain, final String portProperty, final String bindingName) {
        super.log.logf(FQCN, TRACE, cause, couldNotSetAddressAndPortNoMulticastSocket$str(), protocolName, addressProperty, protocolNameAgain, portProperty, bindingName);
    }
    private static final String couldNotSetAddressAndPortNoMulticastSocket = "DGJGRP0004: Could not set %s.%s and %s.%s, %s socket binding does not specify a multicast socket";
    protected String couldNotSetAddressAndPortNoMulticastSocket$str() {
        return couldNotSetAddressAndPortNoMulticastSocket;
    }
    @Override
    public final void unableToAccessProtocolPropertyValue(final Throwable cause, final String propertyName, final String protocolName) {
        super.log.logf(FQCN, ERROR, cause, unableToAccessProtocolPropertyValue$str(), propertyName, protocolName);
    }
    private static final String unableToAccessProtocolPropertyValue = "DGJGRP0005: Error accessing original value for property %s of protocol %s";
    protected String unableToAccessProtocolPropertyValue$str() {
        return unableToAccessProtocolPropertyValue;
    }
    @Override
    public final void unableToOverrideSocketBindingValue(final String propertyName, final String protocolName, final String bindingName, final Object propertyValue) {
        super.log.logf(FQCN, WARN, null, unableToOverrideSocketBindingValue$str(), propertyName, protocolName, bindingName, propertyValue);
    }
    private static final String unableToOverrideSocketBindingValue = "DGJGRP0006: property %s for protocol %s attempting to override socket binding value %s : property value %s will be ignored";
    protected String unableToOverrideSocketBindingValue$str() {
        return unableToOverrideSocketBindingValue;
    }
    private static final String parserFailure = "DGJGRP0007: Failed to parse %s";
    protected String parserFailure$str() {
        return parserFailure;
    }
    @Override
    public final String parserFailure(final URL url) {
        return String.format(getLoggingLocale(), parserFailure$str(), url);
    }
    private static final String notFound = "DGJGRP0008: Failed to locate %s";
    protected String notFound$str() {
        return notFound;
    }
    @Override
    public final String notFound(final String resource) {
        return String.format(getLoggingLocale(), notFound$str(), resource);
    }
    private static final String duplicateNodeName = "DGJGRP0009: A node named %s already exists in this cluster. Perhaps there is already a server running on this host? If so, restart this server with a unique node name, via -Djboss.node.name=<node-name>";
    protected String duplicateNodeName$str() {
        return duplicateNodeName;
    }
    @Override
    public final IllegalStateException duplicateNodeName(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), duplicateNodeName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transportNotDefined = "DGJGRP0010: Transport for stack %s is not defined. Please specify both a transport and protocol list, either as optional parameters to add() or via batching.";
    protected String transportNotDefined$str() {
        return transportNotDefined;
    }
    @Override
    public final OperationFailedException transportNotDefined(final String stackName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), transportNotDefined$str(), stackName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String protocolListNotDefined = "DGJGRP0011: Protocol list for stack %s is not defined. Please specify both a transport and protocol list, either as optional parameters to add() or via batching.";
    protected String protocolListNotDefined$str() {
        return protocolListNotDefined;
    }
    @Override
    public final OperationFailedException protocolListNotDefined(final String stackName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), protocolListNotDefined$str(), stackName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String protocolAlreadyDefined = "DGJGRP0012: Protocol with relative path %s is already defined.";
    protected String protocolAlreadyDefined$str() {
        return protocolAlreadyDefined;
    }
    @Override
    public final OperationFailedException protocolAlreadyDefined(final String relativePath) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), protocolAlreadyDefined$str(), relativePath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String protocolNotDefined = "DGJGRP0013: Protocol with relative path %s is not defined.";
    protected String protocolNotDefined$str() {
        return protocolNotDefined;
    }
    @Override
    public final OperationFailedException protocolNotDefined(final String relativePath) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), protocolNotDefined$str(), relativePath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String propertyNotDefined = "DGJGRP0014: Property %s for protocol with relative path %s is not defined.";
    protected String propertyNotDefined$str() {
        return propertyNotDefined;
    }
    @Override
    public final OperationFailedException propertyNotDefined(final String propertyName, final String protocolRelativePath) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), propertyNotDefined$str(), propertyName, protocolRelativePath));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownMetric = "DGJGRP0015: Unknown metric %s";
    protected String unknownMetric$str() {
        return unknownMetric;
    }
    @Override
    public final String unknownMetric(final String metricName) {
        return String.format(getLoggingLocale(), unknownMetric$str(), metricName);
    }
    private static final String unableToLoadProtocolClass = "DGJGRP0016: Unable to load protocol class %s";
    protected String unableToLoadProtocolClass$str() {
        return unableToLoadProtocolClass;
    }
    @Override
    public final OperationFailedException unableToLoadProtocolClass(final String protocolName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToLoadProtocolClass$str(), protocolName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String privilegedAccessExceptionForAttribute = "DGJGRP0017: Privileged access exception on attribute/method %s";
    protected String privilegedAccessExceptionForAttribute$str() {
        return privilegedAccessExceptionForAttribute;
    }
    @Override
    public final String privilegedAccessExceptionForAttribute(final String attrName) {
        return String.format(getLoggingLocale(), privilegedAccessExceptionForAttribute$str(), attrName);
    }
    private static final String instantiationExceptionOnConverterForAttribute = "DGJGRP0018: Instantiation exception on converter for attribute/method %s";
    protected String instantiationExceptionOnConverterForAttribute$str() {
        return instantiationExceptionOnConverterForAttribute;
    }
    @Override
    public final String instantiationExceptionOnConverterForAttribute(final String attrName) {
        return String.format(getLoggingLocale(), instantiationExceptionOnConverterForAttribute$str(), attrName);
    }
    private static final String protocolNotFoundInStack = "DGJGRP0019: Protocol %s not found in current stack";
    protected String protocolNotFoundInStack$str() {
        return protocolNotFoundInStack;
    }
    @Override
    public final String protocolNotFoundInStack(final String protocolName) {
        return String.format(getLoggingLocale(), protocolNotFoundInStack$str(), protocolName);
    }
    private static final String unableToLoadProtocol = "DGJGRP0020: Unable to load protocol class %s";
    protected String unableToLoadProtocol$str() {
        return unableToLoadProtocol;
    }
    @Override
    public final String unableToLoadProtocol(final String protocolName) {
        return String.format(getLoggingLocale(), unableToLoadProtocol$str(), protocolName);
    }
    private static final String threadsAttributesUsedInRuntime = "DGJGRP0021: Attributes referencing threads subsystem can only be used to support older slaves in the domain.";
    protected String threadsAttributesUsedInRuntime$str() {
        return threadsAttributesUsedInRuntime;
    }
    @Override
    public final String threadsAttributesUsedInRuntime() {
        return String.format(getLoggingLocale(), threadsAttributesUsedInRuntime$str());
    }
    private static final String unauthorizedNodeJoin = "DGJGRP0100: Unauthorized node %s attempting to join cluster.";
    protected String unauthorizedNodeJoin$str() {
        return unauthorizedNodeJoin;
    }
    @Override
    public final SecurityException unauthorizedNodeJoin(final String nodeName) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unauthorizedNodeJoin$str(), nodeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void receivedXSiteClusterView(final java.util.Set<String> view) {
        super.log.logf(FQCN, INFO, null, receivedXSiteClusterView$str(), view);
    }
    private static final String receivedXSiteClusterView = "DGJGRP0101: Received new x-site view: %s";
    protected String receivedXSiteClusterView$str() {
        return receivedXSiteClusterView;
    }
}
