/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.session;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractInfinispanSessionRepository;
import org.infinispan.test.AbstractInfinispanTest;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.FlushMode;
import org.springframework.session.SaveMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class InfinispanSessionRepositoryTCK
extends AbstractInfinispanTest {
    protected SpringCache springCache;
    protected AbstractInfinispanSessionRepository sessionRepository;
    protected MediaType mediaType;

    protected InfinispanSessionRepositoryTCK mediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    protected String parameters() {
        return this.mediaType.toString();
    }

    protected abstract SpringCache createSpringCache();

    protected abstract AbstractInfinispanSessionRepository createRepository(SpringCache var1) throws Exception;

    protected void init() throws Exception {
        this.springCache = this.createSpringCache();
        this.sessionRepository = this.createRepository(this.springCache);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testThrowingExceptionOnNullSpringCache() throws Exception {
        this.createRepository(null);
    }

    @Test
    public void testCreatingSession() throws Exception {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        AssertJUnit.assertNotNull((Object)session.getId());
        AssertJUnit.assertNotNull((Object)session.getCreationTime());
        AssertJUnit.assertNull((Object)this.sessionRepository.findById(session.getId()));
    }

    @Test
    public void testSavingNewSession() throws Exception {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        Instant lastAccessedTime = session.getLastAccessedTime();
        Duration maxInactiveInterval = session.getMaxInactiveInterval();
        this.sessionRepository.save(session);
        AbstractInfinispanSessionRepository.InfinispanSession savedSession = this.sessionRepository.findById(session.getId());
        AssertJUnit.assertNotNull((Object)savedSession);
        AssertJUnit.assertTrue((boolean)savedSession.getAttributeNames().isEmpty());
        AssertJUnit.assertEquals((Object)lastAccessedTime.truncatedTo(ChronoUnit.MILLIS), (Object)savedSession.getLastAccessedTime().truncatedTo(ChronoUnit.MILLIS));
        AssertJUnit.assertEquals((Object)maxInactiveInterval, (Object)savedSession.getMaxInactiveInterval());
    }

    @Test
    public void testSavingUnchangedSession() throws Exception {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        Instant lastAccessedTime = session.getLastAccessedTime();
        Duration maxInactiveInterval = session.getMaxInactiveInterval();
        this.sessionRepository.save(session);
        session = this.sessionRepository.findById(session.getId());
        this.sessionRepository.save(session);
        AbstractInfinispanSessionRepository.InfinispanSession updatedSession = this.sessionRepository.findById(session.getId());
        AssertJUnit.assertTrue((boolean)updatedSession.getAttributeNames().isEmpty());
        AssertJUnit.assertEquals((Object)lastAccessedTime.truncatedTo(ChronoUnit.MILLIS), (Object)updatedSession.getLastAccessedTime().truncatedTo(ChronoUnit.MILLIS));
        AssertJUnit.assertEquals((Object)maxInactiveInterval, (Object)updatedSession.getMaxInactiveInterval());
    }

    @Test
    public void testSavingSessionWithUpdatedMaxInactiveInterval() throws Exception {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        this.sessionRepository.save(session);
        session = this.sessionRepository.findById(session.getId());
        Duration newMaxInactiveInterval = Duration.ofSeconds(123L);
        session.setMaxInactiveInterval(newMaxInactiveInterval);
        this.sessionRepository.save(session);
        AbstractInfinispanSessionRepository.InfinispanSession savedSession = this.sessionRepository.findById(session.getId());
        AssertJUnit.assertEquals((Object)newMaxInactiveInterval, (Object)savedSession.getMaxInactiveInterval());
    }

    @Test
    public void testSavingSessionWithUpdatedLastAccessedTime() throws Exception {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        this.sessionRepository.save(session);
        session = this.sessionRepository.findById(session.getId());
        Instant newLastAccessedTime = Instant.now().minusSeconds(300L);
        session.setLastAccessedTime(newLastAccessedTime);
        this.sessionRepository.save(session);
        AbstractInfinispanSessionRepository.InfinispanSession savedSession = this.sessionRepository.findById(session.getId());
        AssertJUnit.assertEquals((Object)newLastAccessedTime.truncatedTo(ChronoUnit.MILLIS), (Object)savedSession.getLastAccessedTime().truncatedTo(ChronoUnit.MILLIS));
    }

    @Test
    public void testSavingSessionWithUpdatedAttributes() throws Exception {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        session.setAttribute("changed", (Object)"oldValue");
        session.setAttribute("removed", (Object)"existingValue");
        this.sessionRepository.save(session);
        session = this.sessionRepository.findById(session.getId());
        session.setAttribute("added", (Object)"addedValue");
        session.setAttribute("changed", (Object)"newValue");
        session.removeAttribute("removed");
        this.sessionRepository.save(session);
        AbstractInfinispanSessionRepository.InfinispanSession savedSession = this.sessionRepository.findById(session.getId());
        AssertJUnit.assertEquals((String)((String)savedSession.getAttribute("added")), (String)"addedValue");
        AssertJUnit.assertEquals((String)((String)savedSession.getAttribute("changed")), (String)"newValue");
        AssertJUnit.assertNull((Object)savedSession.getAttribute("removed"));
    }

    @Test
    public void testUpdatingTTLOnAccessingData() throws Exception {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        long accessTimeBeforeSaving = session.getLastAccessedTime().toEpochMilli();
        this.sessionRepository.save(session);
        long accessTimeAfterSaving = session.getLastAccessedTime().toEpochMilli();
        long accessTimeAfterAccessing = this.sessionRepository.findById(session.getId()).getLastAccessedTime().toEpochMilli();
        long now = Instant.now().toEpochMilli();
        AssertJUnit.assertTrue((accessTimeBeforeSaving > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((accessTimeBeforeSaving <= now ? 1 : 0) != 0);
        AssertJUnit.assertTrue((accessTimeAfterSaving > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((accessTimeAfterSaving <= now ? 1 : 0) != 0);
        AssertJUnit.assertTrue((accessTimeAfterAccessing > 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((accessTimeAfterAccessing >= accessTimeAfterSaving ? 1 : 0) != 0);
    }

    @Test
    public void testDeletingSession() throws Exception {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        this.sessionRepository.save(session);
        this.sessionRepository.deleteById(session.getId());
        AssertJUnit.assertNull((Object)this.sessionRepository.findById(session.getId()));
    }

    @Test(timeOut=5000L)
    public void testEvictingSession() throws Exception {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        session.setMaxInactiveInterval(Duration.ofSeconds(1L));
        this.sessionRepository.save(session);
        while (this.sessionRepository.findById(session.getId()) != null) {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
    }

    @Test
    public void testExtractingPrincipalWithWrongIndexName() throws Exception {
        int sizeWithWrongIndexName = this.sessionRepository.findByIndexNameAndIndexValue("wrongIndexName", "").size();
        int sizeWithNullIndexName = this.sessionRepository.findByIndexNameAndIndexValue(null, "").size();
        AssertJUnit.assertEquals((int)0, (int)sizeWithNullIndexName);
        AssertJUnit.assertEquals((int)0, (int)sizeWithWrongIndexName);
    }

    @Test
    public void testExtractingPrincipal() throws Exception {
        this.addEmptySessionWithPrincipal(this.sessionRepository, "test1");
        this.addEmptySessionWithPrincipal(this.sessionRepository, "test2");
        this.addEmptySessionWithPrincipal(this.sessionRepository, "test3");
        int numberOfTest1Users = this.sessionRepository.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, "test1").size();
        int numberOfNonExistingUsers = this.sessionRepository.findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, "notExisting").size();
        AssertJUnit.assertEquals((int)1, (int)numberOfTest1Users);
        AssertJUnit.assertEquals((int)0, (int)numberOfNonExistingUsers);
    }

    @Test
    public void testChangeSessionId() throws Exception {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        String originalId = session.getId();
        this.sessionRepository.save(session);
        session.changeSessionId();
        String newId = session.getId();
        this.sessionRepository.save(session);
        AssertJUnit.assertNotNull((Object)this.sessionRepository.findById(newId));
        AssertJUnit.assertNull((Object)this.sessionRepository.findById(originalId));
        this.sessionRepository.save(session);
        AssertJUnit.assertNotNull((Object)this.sessionRepository.findById(newId));
        AssertJUnit.assertNull((Object)this.sessionRepository.findById(originalId));
    }

    @Test
    public void testConcurrentSessionAccess() {
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        session.setLastAccessedTime(Instant.now());
        session.setAttribute("testAttribute", (Object)"oldValue");
        this.sessionRepository.save(session);
        AbstractInfinispanSessionRepository.InfinispanSession slowRequestSession = this.sessionRepository.findById(session.getId());
        slowRequestSession.setLastAccessedTime(Instant.now());
        slowRequestSession.getAttribute("testAttribute");
        AbstractInfinispanSessionRepository.InfinispanSession fastRequestSession = this.sessionRepository.findById(session.getId());
        fastRequestSession.setLastAccessedTime(Instant.now());
        fastRequestSession.setAttribute("testAttribute", (Object)"fastValue");
        this.sessionRepository.save(fastRequestSession);
        this.sessionRepository.save(slowRequestSession);
        AssertJUnit.assertNotSame((Object)slowRequestSession, (Object)fastRequestSession);
        AbstractInfinispanSessionRepository.InfinispanSession updatedSession = this.sessionRepository.findById(session.getId());
        AssertJUnit.assertEquals((String)"fastValue", (String)((String)updatedSession.getAttribute("testAttribute")));
    }

    @Test
    public void testConcurrentSessionAccessWithSaveModeOnGetAttribute() {
        this.sessionRepository.setSaveMode(SaveMode.ON_GET_ATTRIBUTE);
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        session.setLastAccessedTime(Instant.now());
        session.setAttribute("testAttribute", (Object)"oldValue");
        this.sessionRepository.save(session);
        AbstractInfinispanSessionRepository.InfinispanSession slowRequestSession = this.sessionRepository.findById(session.getId());
        slowRequestSession.setLastAccessedTime(Instant.now());
        slowRequestSession.getAttribute("testAttribute");
        AbstractInfinispanSessionRepository.InfinispanSession fastRequestSession = this.sessionRepository.findById(session.getId());
        fastRequestSession.setLastAccessedTime(Instant.now());
        fastRequestSession.setAttribute("testAttribute", (Object)"fastValue");
        this.sessionRepository.save(fastRequestSession);
        this.sessionRepository.save(slowRequestSession);
        AssertJUnit.assertNotSame((Object)slowRequestSession, (Object)fastRequestSession);
        AbstractInfinispanSessionRepository.InfinispanSession updatedSession = this.sessionRepository.findById(session.getId());
        AssertJUnit.assertEquals((String)"oldValue", (String)((String)updatedSession.getAttribute("testAttribute")));
    }

    @Test
    public void testConcurrentSessionAccessWithSaveModeAlways() {
        this.sessionRepository.setSaveMode(SaveMode.ALWAYS);
        AbstractInfinispanSessionRepository.InfinispanSession session = this.sessionRepository.createSession();
        session.setLastAccessedTime(Instant.now());
        session.setAttribute("testAttribute", (Object)"oldValue");
        this.sessionRepository.save(session);
        AbstractInfinispanSessionRepository.InfinispanSession slowRequestSession = this.sessionRepository.findById(session.getId());
        slowRequestSession.setLastAccessedTime(Instant.now());
        AbstractInfinispanSessionRepository.InfinispanSession fastRequestSession = this.sessionRepository.findById(session.getId());
        fastRequestSession.setLastAccessedTime(Instant.now());
        fastRequestSession.setAttribute("testAttribute", (Object)"fastValue");
        this.sessionRepository.save(fastRequestSession);
        this.sessionRepository.save(slowRequestSession);
        AssertJUnit.assertNotSame((Object)slowRequestSession, (Object)fastRequestSession);
        AbstractInfinispanSessionRepository.InfinispanSession updatedSession = this.sessionRepository.findById(session.getId());
        AssertJUnit.assertEquals((String)"oldValue", (String)((String)updatedSession.getAttribute("testAttribute")));
    }

    @Test
    public void testFlushModeImmediate() throws Exception {
        this.sessionRepository.setFlushMode(FlushMode.IMMEDIATE);
        AbstractInfinispanSessionRepository.InfinispanSession existingSession = this.sessionRepository.createSession();
        AbstractInfinispanSessionRepository.InfinispanSession newSession = this.sessionRepository.createSession();
        existingSession.setAttribute("testAttribute", (Object)"testValue");
        AbstractInfinispanSessionRepository.InfinispanSession savedNewSession = this.sessionRepository.findById(newSession.getId());
        AssertJUnit.assertNotNull((Object)savedNewSession);
        AbstractInfinispanSessionRepository.InfinispanSession savedExistingSession = this.sessionRepository.findById(existingSession.getId());
        AssertJUnit.assertEquals((String)"testValue", (String)((String)savedExistingSession.getAttribute("testAttribute")));
    }

    protected void addEmptySessionWithPrincipal(AbstractInfinispanSessionRepository sessionRepository, String principalName) {
        AbstractInfinispanSessionRepository.InfinispanSession session = sessionRepository.createSession();
        session.setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, (Object)principalName);
        sessionRepository.save(session);
    }
}

