/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.session;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractApplicationPublisherBridge;
import org.infinispan.spring.common.session.SessionUpdateRemappingFunction;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.session.DelegatingIndexResolver;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.FlushMode;
import org.springframework.session.IndexResolver;
import org.springframework.session.MapSession;
import org.springframework.session.PrincipalNameIndexResolver;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.util.Assert;

public abstract class AbstractInfinispanSessionRepository
implements FindByIndexNameSessionRepository<InfinispanSession>,
ApplicationEventPublisherAware,
InitializingBean,
DisposableBean {
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    protected final AbstractApplicationPublisherBridge applicationEventPublisher;
    protected final SpringCache cache;
    protected final BasicCache<String, MapSession> nativeCache;
    protected Duration defaultMaxInactiveInterval = Duration.ofSeconds(1800L);
    protected FlushMode flushMode = FlushMode.ON_SAVE;
    protected SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    protected IndexResolver<Session> indexResolver = new DelegatingIndexResolver(new IndexResolver[]{new PrincipalNameIndexResolver()});

    protected AbstractInfinispanSessionRepository(SpringCache cache, AbstractApplicationPublisherBridge eventsBridge) {
        Objects.requireNonNull(cache, "SpringCache can not be null");
        Objects.requireNonNull(eventsBridge, "EventBridge can not be null");
        this.applicationEventPublisher = eventsBridge;
        this.cache = cache;
        this.nativeCache = cache.getNativeCache();
    }

    public void afterPropertiesSet() {
        this.applicationEventPublisher.registerListener();
    }

    public void destroy() {
        this.applicationEventPublisher.unregisterListener();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher.setApplicationEventPublisher(applicationEventPublisher);
    }

    public void setDefaultMaxInactiveInterval(Duration defaultMaxInactiveInterval) {
        Assert.notNull((Object)defaultMaxInactiveInterval, (String)"defaultMaxInactiveInterval must not be null");
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        Assert.notNull(indexResolver, (String)"indexResolver cannot be null");
        this.indexResolver = indexResolver;
    }

    public void setFlushMode(FlushMode flushMode) {
        Assert.notNull((Object)flushMode, (String)"flushMode cannot be null");
        this.flushMode = flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        Assert.notNull((Object)saveMode, (String)"saveMode must not be null");
        this.saveMode = saveMode;
    }

    public InfinispanSession createSession() {
        MapSession cached = new MapSession();
        cached.setMaxInactiveInterval(this.defaultMaxInactiveInterval);
        cached.setCreationTime(Instant.now());
        InfinispanSession session = new InfinispanSession(cached, true);
        session.flushImmediateIfNecessary();
        return session;
    }

    public void save(InfinispanSession session) {
        if (session.isNew) {
            this.nativeCache.put((Object)session.getId(), (Object)session.getDelegate(), session.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
        } else if (session.sessionIdChanged) {
            this.removeFromCacheWithoutNotifications(session.originalId);
            session.originalId = session.getId();
            this.nativeCache.put((Object)session.getId(), (Object)session.getDelegate(), session.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
        } else if (session.hasChanges()) {
            SessionUpdateRemappingFunction remappingFunction = new SessionUpdateRemappingFunction();
            if (session.lastAccessedTimeChanged) {
                remappingFunction.setLastAccessedTime(session.getLastAccessedTime());
            }
            if (session.maxInactiveIntervalChanged) {
                remappingFunction.setMaxInactiveInterval(session.getMaxInactiveInterval());
            }
            if (!session.delta.isEmpty()) {
                remappingFunction.setDelta(new HashMap<String, Object>(session.delta));
            }
            this.nativeCache.compute((Object)session.getId(), (BiFunction)remappingFunction, session.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
        }
        session.clearChangeFlags();
    }

    protected abstract void removeFromCacheWithoutNotifications(String var1);

    public InfinispanSession findById(String id) {
        MapSession saved = (MapSession)this.nativeCache.get((Object)id);
        if (saved == null) {
            return null;
        }
        if (saved.isExpired()) {
            this.deleteById(saved.getId());
            return null;
        }
        return new InfinispanSession(saved, false);
    }

    public void deleteById(String id) {
        MapSession saved = (MapSession)this.nativeCache.get((Object)id);
        if (saved != null) {
            this.applicationEventPublisher.emitSessionDeletedEvent((Session)saved);
            this.nativeCache.remove((Object)id);
        }
    }

    public final class InfinispanSession
    implements Session {
        private final MapSession delegate;
        private boolean isNew;
        private boolean sessionIdChanged;
        private boolean lastAccessedTimeChanged;
        private boolean maxInactiveIntervalChanged;
        private String originalId;
        private final Map<String, Object> delta = new HashMap<String, Object>();

        public InfinispanSession(MapSession cached, boolean isNew) {
            this.delegate = isNew ? cached : new MapSession((Session)cached);
            this.isNew = isNew;
            this.originalId = cached.getId();
            if (this.isNew || AbstractInfinispanSessionRepository.this.saveMode == SaveMode.ALWAYS) {
                this.getAttributeNames().forEach(attributeName -> this.delta.put((String)attributeName, cached.getAttribute(attributeName)));
            }
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.delegate.setLastAccessedTime(lastAccessedTime);
            this.lastAccessedTimeChanged = true;
            this.flushImmediateIfNecessary();
        }

        public boolean isExpired() {
            return this.delegate.isExpired();
        }

        public Instant getCreationTime() {
            return this.delegate.getCreationTime();
        }

        public String getId() {
            return this.delegate.getId();
        }

        public String changeSessionId() {
            String newSessionId = this.delegate.changeSessionId();
            this.sessionIdChanged = true;
            return newSessionId;
        }

        public Instant getLastAccessedTime() {
            return this.delegate.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            this.delegate.setMaxInactiveInterval(interval);
            this.maxInactiveIntervalChanged = true;
            this.flushImmediateIfNecessary();
        }

        public Duration getMaxInactiveInterval() {
            return this.delegate.getMaxInactiveInterval();
        }

        public <T> T getAttribute(String attributeName) {
            Object attributeValue = this.delegate.getAttribute(attributeName);
            if (attributeValue != null && AbstractInfinispanSessionRepository.this.saveMode.equals((Object)SaveMode.ON_GET_ATTRIBUTE)) {
                this.delta.put(attributeName, attributeValue);
            }
            return (T)attributeValue;
        }

        public Set<String> getAttributeNames() {
            return this.delegate.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            this.delegate.setAttribute(attributeName, attributeValue);
            this.delta.put(attributeName, attributeValue);
            if (AbstractInfinispanSessionRepository.SPRING_SECURITY_CONTEXT.equals(attributeName)) {
                Map indexes = AbstractInfinispanSessionRepository.this.indexResolver.resolveIndexesFor((Session)this);
                String principal = attributeValue != null ? (String)indexes.get(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME) : null;
                this.delegate.setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, (Object)principal);
                this.delta.put(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, principal);
            }
            this.flushImmediateIfNecessary();
        }

        public void removeAttribute(String attributeName) {
            this.setAttribute(attributeName, null);
        }

        MapSession getDelegate() {
            return this.delegate;
        }

        boolean hasChanges() {
            return this.lastAccessedTimeChanged || this.maxInactiveIntervalChanged || !this.delta.isEmpty();
        }

        void clearChangeFlags() {
            this.isNew = false;
            this.lastAccessedTimeChanged = false;
            this.sessionIdChanged = false;
            this.maxInactiveIntervalChanged = false;
            this.delta.clear();
        }

        private void flushImmediateIfNecessary() {
            if (AbstractInfinispanSessionRepository.this.flushMode == FlushMode.IMMEDIATE) {
                AbstractInfinispanSessionRepository.this.save(this);
            }
        }
    }
}

