/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.common.session;

import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.spring.common.provider.SpringCache;
import org.infinispan.spring.common.session.AbstractApplicationPublisherBridge;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.MapSession;
import org.springframework.session.Session;

public abstract class AbstractInfinispanSessionRepository
implements FindByIndexNameSessionRepository<MapSession>,
ApplicationEventPublisherAware,
InitializingBean,
DisposableBean {
    protected final AbstractApplicationPublisherBridge applicationEventPublisher;
    protected final SpringCache cache;

    protected AbstractInfinispanSessionRepository(SpringCache cache, AbstractApplicationPublisherBridge eventsBridge) {
        Objects.requireNonNull(cache, "SpringCache can not be null");
        Objects.requireNonNull(eventsBridge, "EventBridge can not be null");
        this.applicationEventPublisher = eventsBridge;
        this.cache = cache;
    }

    public void afterPropertiesSet() {
        this.applicationEventPublisher.registerListener();
    }

    public void destroy() {
        this.applicationEventPublisher.unregisterListener();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher.setApplicationEventPublisher(applicationEventPublisher);
    }

    public MapSession createSession() {
        MapSession result = new MapSession();
        result.setCreationTime(Instant.now());
        return result;
    }

    public void save(MapSession session) {
        if (!session.getId().equals(session.getOriginalId())) {
            this.removeFromCacheWithoutNotifications(session.getOriginalId());
        }
        this.cache.put(session.getId(), session, session.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
    }

    protected abstract void removeFromCacheWithoutNotifications(String var1);

    public MapSession findById(String sessionId) {
        return this.getSession(sessionId, true);
    }

    public void deleteById(String sessionId) {
        Cache.ValueWrapper valueWrapper = this.cache.get(sessionId);
        if (valueWrapper == null) {
            return;
        }
        MapSession mapSession = (MapSession)valueWrapper.get();
        if (mapSession != null) {
            this.applicationEventPublisher.emitSessionDeletedEvent((Session)mapSession);
            this.cache.evict(sessionId);
        }
    }

    public MapSession getSession(String id, boolean updateTTL) {
        Cache.ValueWrapper wrapper = this.cache.get(id);
        if (wrapper == null) {
            return null;
        }
        MapSession session = (MapSession)wrapper.get();
        assert (session != null);
        return this.updateTTL(new MapSession((Session)session), updateTTL);
    }

    protected MapSession updateTTL(MapSession session, boolean updateTTL) {
        if (updateTTL) {
            session.setLastAccessedTime(Instant.now());
            this.cache.put(session.getId(), session, session.getMaxInactiveInterval().getSeconds(), TimeUnit.SECONDS);
        }
        return session;
    }
}

